﻿/*
 * Copyright (C) 2019 Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU  Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/&gt;.
 *
 */
#include "frmlunarcalendarwidget.h"
#include "ui_frmlunarcalendarwidget.h"
#include <QPainter>
#include <KWindowEffects>

#define TRANSPARENCY_SETTINGS       "org.ukui.control-center.personalise"
#define TRANSPARENCY_KEY            "transparency"
#define PANEL_CONTROL_IN_CALENDAR "org.ukui.control-center.panel.plugins"
#define LUNAR_KEY "calendar"
#define FIRST_DAY_KEY "firstday"

const int CALENDAR_WIDTH = 440;
const int CALENDAR_HEIGHT = 500;
const int CALENDAR_LUNAR_HEIGHT = 75;
const int CALENDAR_LUNAR_HEIGHT_PLUSE = 77;

frmLunarCalendarWidget::frmLunarCalendarWidget(QWidget *parent) : QWidget(parent), ui(new Ui::frmLunarCalendarWidget)
{
    installEventFilter(this);
    ui->setupUi(this);
    connect(ui->lunarCalendarWidget,&LunarCalendarWidget::almanacChanged,this,&frmLunarCalendarWidget::showAlmanac);
    connect(this, &frmLunarCalendarWidget::onShowToday,ui->lunarCalendarWidget,&LunarCalendarWidget::showToday);
    this->initForm();
    //默认展开状态
    bool showLunar = ui->lunarCalendarWidget->getShowLunar();
    if(showLunar)
        this->setFixedSize(CALENDAR_WIDTH, CALENDAR_HEIGHT+CALENDAR_LUNAR_HEIGHT+CALENDAR_LUNAR_HEIGHT_PLUSE);
    else
        this->setFixedSize(CALENDAR_WIDTH,CALENDAR_HEIGHT);

    const QByteArray transparency_id(TRANSPARENCY_SETTINGS);
    if(QGSettings::isSchemaInstalled(transparency_id)){
        transparency_gsettings = new QGSettings(transparency_id);
    }
    const QByteArray calendar_id(PANEL_CONTROL_IN_CALENDAR);
    if(QGSettings::isSchemaInstalled(calendar_id)){
        calendar_gsettings = new QGSettings(calendar_id);
        //公历/农历切换
        connect(calendar_gsettings, &QGSettings::changed, this, [=] (const QString &key){
            if(key == LUNAR_KEY){
                ckShowLunar_stateChanged(calendar_gsettings->get(LUNAR_KEY).toString() == "lunar");
            }
            if (key == FIRST_DAY_KEY) {
                cboxWeekNameFormat_currentIndexChanged(calendar_gsettings->get(FIRST_DAY_KEY).toString() == "sunday");
            }
        });
    } else {
        ckShowLunar_stateChanged(false);
        cboxWeekNameFormat_currentIndexChanged(false);
    }
    setProperty("useStyleWindowManager",false);
}

frmLunarCalendarWidget::~frmLunarCalendarWidget()
{
    delete ui;
}

void frmLunarCalendarWidget::showAlmanac(bool big)
{
    qDebug() << __FILE__ <<__LINE__<<__FUNCTION__<<big;
    if(big){
        setFixedHeight(CALENDAR_HEIGHT+CALENDAR_LUNAR_HEIGHT+CALENDAR_LUNAR_HEIGHT_PLUSE);
    }else{
        setFixedHeight(CALENDAR_HEIGHT);
    }
}

void frmLunarCalendarWidget::changeUpSize()
{
    yijiIsUp = true;
    this->setFixedSize(CALENDAR_WIDTH, CALENDAR_HEIGHT+CALENDAR_LUNAR_HEIGHT+CALENDAR_LUNAR_HEIGHT_PLUSE);
    Q_EMIT yijiFChangeUp();
}

void frmLunarCalendarWidget::changeDownSize()
{
    yijiIsUp = false;
    this->setFixedSize(CALENDAR_WIDTH, CALENDAR_HEIGHT+CALENDAR_LUNAR_HEIGHT);
    Q_EMIT yijiFChangeDown();
}

void frmLunarCalendarWidget::initForm()
{
    //ui->cboxWeekNameFormat->setCurrentIndex(0);
}

void frmLunarCalendarWidget::cboxCalendarStyle_currentIndexChanged(int index)
{
    ui->lunarCalendarWidget->setCalendarStyle((LunarCalendarWidget::CalendarStyle)index);
}

void frmLunarCalendarWidget::cboxSelectType_currentIndexChanged(int index)
{
    ui->lunarCalendarWidget->setSelectType((LunarCalendarWidget::SelectType)index);
}

void frmLunarCalendarWidget::cboxWeekNameFormat_currentIndexChanged(bool FirstDayisSun)
{
    ui->lunarCalendarWidget->setWeekNameFormat(FirstDayisSun);
}

void frmLunarCalendarWidget::ckShowLunar_stateChanged(bool arg1)
{
    if (arg1) {
        if (yijiIsUp) {
            this->setFixedSize(CALENDAR_WIDTH,CALENDAR_HEIGHT+CALENDAR_LUNAR_HEIGHT+CALENDAR_LUNAR_HEIGHT_PLUSE);
        } else {
            this->setFixedSize(CALENDAR_WIDTH,CALENDAR_HEIGHT+CALENDAR_LUNAR_HEIGHT);
        }
    } else {
        this->setFixedSize(CALENDAR_WIDTH,CALENDAR_HEIGHT);
    }
}

void frmLunarCalendarWidget::paintEvent(QPaintEvent *)
{
    QStyleOption opt;
    opt.init(this);
    QRect rect = this->rect();
    QPainter p(this);
    double tran =1;
    const QByteArray transparency_id(TRANSPARENCY_SETTINGS);
    if(QGSettings::isSchemaInstalled(transparency_id)){
       tran=transparency_gsettings->get(TRANSPARENCY_KEY).toDouble()*255;
    }

    QColor color = palette().color(QPalette::Base);
    color.setAlpha(tran);
    QBrush brush =QBrush(color);
    p.setBrush(brush);
    p.setPen(Qt::NoPen);
    p.setRenderHint(QPainter::Antialiasing);
    p.drawRoundedRect(rect,6,6);
    style()->drawPrimitive(QStyle::PE_Widget, &opt, &p, this);
}

/*
 * 事件过滤，检测鼠标点击外部活动区域则收回收纳栏
*/
bool frmLunarCalendarWidget::eventFilter(QObject *obj, QEvent *event)
{
    if (obj == this)
    {
        if (event->type() == QEvent::MouseButtonPress)
           {
               QMouseEvent *mouseEvent = static_cast<QMouseEvent *>(event);
               if (mouseEvent->button() == Qt::LeftButton)
               {
//                   this->hide();
//                   status=ST_HIDE;
                   return true;
               }
               else if(mouseEvent->button() == Qt::RightButton)
               {
                   return true;
               }
           }
        else if(event->type() == QEvent::ContextMenu)
        {
            return false;
        }
        else if (event->type() == QEvent::WindowDeactivate)
        {
            //qDebug()<<"激活外部窗口";
            this->hide();
            return true;
        } else if (event->type() == QEvent::StyleChange) {
        }
    }

    if (!isActiveWindow())
    {
        activateWindow();
    }
    return false;
}
