require_relative "../../../base"

require "vagrant/util/template_renderer"

describe "templates/guests/fedora/network_static" do
  let(:template) { "guests/fedora/network_static" }

  it "renders the template" do
    result = Vagrant::Util::TemplateRenderer.render(template, options: {
      device:  "en0",
      ip:      "1.1.1.1",
      netmask: "255.255.0.0",
    })
    expect(result).to eq <<-EOH.gsub(/^ {6}/, "")
      #VAGRANT-BEGIN
      # The contents below are automatically generated by Vagrant. Do not modify.
      NM_CONTROLLED=no
      BOOTPROTO=none
      ONBOOT=yes
      IPADDR=1.1.1.1
      NETMASK=255.255.0.0
      DEVICE=en0
      PEERDNS=no
      #VAGRANT-END
    EOH
  end

  it "includes the gateway" do
    result = Vagrant::Util::TemplateRenderer.render(template, options: {
      device:  "en0",
      ip:      "1.1.1.1",
      netmask: "255.255.0.0",
      gateway: "1.2.3.4",
    })
    expect(result).to eq <<-EOH.gsub(/^ {6}/, "")
      #VAGRANT-BEGIN
      # The contents below are automatically generated by Vagrant. Do not modify.
      NM_CONTROLLED=no
      BOOTPROTO=none
      ONBOOT=yes
      IPADDR=1.1.1.1
      NETMASK=255.255.0.0
      DEVICE=en0
      GATEWAY=1.2.3.4
      PEERDNS=no
      #VAGRANT-END
    EOH
  end

  it "includes the mac_address" do
    result = Vagrant::Util::TemplateRenderer.render(template, options: {
      device:      "en0",
      ip:          "1.1.1.1",
      netmask:     "255.255.0.0",
      mac_address: "abcd1234",
    })
    expect(result).to eq <<-EOH.gsub(/^ {6}/, "")
      #VAGRANT-BEGIN
      # The contents below are automatically generated by Vagrant. Do not modify.
      NM_CONTROLLED=no
      BOOTPROTO=none
      ONBOOT=yes
      IPADDR=1.1.1.1
      NETMASK=255.255.0.0
      DEVICE=en0
      HWADDR=abcd1234
      PEERDNS=no
      #VAGRANT-END
    EOH
  end
end
