/* valaparameter.c generated by valac, the Vala compiler
 * generated from valaparameter.vala, do not modify */

/* valaparameter.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaParameterPrivate {
	ValaParameterDirection _direction;
	gboolean _ellipsis;
	gboolean _params_array;
	gboolean _captured;
	ValaParameter* _base_parameter;
};


static gpointer vala_parameter_parent_class = NULL;

#define VALA_PARAMETER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_PARAMETER, ValaParameterPrivate))
static void vala_parameter_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor);
static void vala_parameter_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor);
static void vala_parameter_real_replace_type (ValaCodeNode* base,
                                       ValaDataType* old_type,
                                       ValaDataType* new_type);
static void vala_parameter_real_replace_expression (ValaCodeNode* base,
                                             ValaExpression* old_node,
                                             ValaExpression* new_node);
static gboolean vala_parameter_real_check (ValaCodeNode* base,
                                    ValaCodeContext* context);
static void vala_parameter_finalize (ValaCodeNode * obj);


/**
 * Creates a new formal parameter.
 *
 * @param name              parameter name
 * @param variable_type     parameter type
 * @param source_reference  reference to source code
 * @return                  newly created formal parameter
 */
ValaParameter*
vala_parameter_construct (GType object_type,
                          const gchar* name,
                          ValaDataType* variable_type,
                          ValaSourceReference* source_reference)
{
	ValaParameter* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaParameter*) vala_variable_construct (object_type, variable_type, name, NULL, source_reference, NULL);
	vala_symbol_set_access ((ValaSymbol*) self, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	return self;
}


ValaParameter*
vala_parameter_new (const gchar* name,
                    ValaDataType* variable_type,
                    ValaSourceReference* source_reference)
{
	return vala_parameter_construct (VALA_TYPE_PARAMETER, name, variable_type, source_reference);
}


/**
 * Creates a new ellipsis parameter representing an indefinite number of
 * parameters.
 */
ValaParameter*
vala_parameter_construct_with_ellipsis (GType object_type,
                                        ValaSourceReference* source_reference)
{
	ValaParameter* self = NULL;
	self = (ValaParameter*) vala_variable_construct (object_type, NULL, NULL, NULL, source_reference, NULL);
	vala_parameter_set_ellipsis (self, TRUE);
	vala_symbol_set_access ((ValaSymbol*) self, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	return self;
}


ValaParameter*
vala_parameter_new_with_ellipsis (ValaSourceReference* source_reference)
{
	return vala_parameter_construct_with_ellipsis (VALA_TYPE_PARAMETER, source_reference);
}


static void
vala_parameter_real_accept (ValaCodeNode* base,
                            ValaCodeVisitor* visitor)
{
	ValaParameter * self;
	self = (ValaParameter*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_formal_parameter (visitor, self);
}


static void
vala_parameter_real_accept_children (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor)
{
	ValaParameter * self;
	gboolean _tmp0_;
	self = (ValaParameter*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = self->priv->_ellipsis;
	if (!_tmp0_) {
		ValaDataType* _tmp1_;
		ValaDataType* _tmp2_;
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp1_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp2_ = _tmp1_;
		vala_code_node_accept ((ValaCodeNode*) _tmp2_, visitor);
		_tmp3_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp4_ = _tmp3_;
		if (_tmp4_ != NULL) {
			ValaExpression* _tmp5_;
			ValaExpression* _tmp6_;
			_tmp5_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp6_ = _tmp5_;
			vala_code_node_accept ((ValaCodeNode*) _tmp6_, visitor);
		}
	}
}


static void
vala_parameter_real_replace_type (ValaCodeNode* base,
                                  ValaDataType* old_type,
                                  ValaDataType* new_type)
{
	ValaParameter * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaParameter*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_variable_set_variable_type ((ValaVariable*) self, new_type);
	}
}


static void
vala_parameter_real_replace_expression (ValaCodeNode* base,
                                        ValaExpression* old_node,
                                        ValaExpression* new_node)
{
	ValaParameter * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaParameter*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_variable_set_initializer ((ValaVariable*) self, new_node);
	}
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


ValaParameter*
vala_parameter_copy (ValaParameter* self)
{
	ValaParameter* result = NULL;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_ellipsis;
	if (!_tmp0_) {
		ValaParameter* _result_ = NULL;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		ValaDataType* _tmp3_;
		ValaDataType* _tmp4_;
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaSourceReference* _tmp8_;
		ValaParameter* _tmp9_;
		ValaParameter* _tmp10_;
		ValaParameter* _tmp11_;
		gboolean _tmp12_;
		ValaParameter* _tmp13_;
		ValaParameterDirection _tmp14_;
		ValaParameter* _tmp15_;
		ValaExpression* _tmp16_;
		ValaExpression* _tmp17_;
		GList* _tmp18_;
		_tmp1_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_data_type_copy (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_parameter_new (_tmp2_, _tmp6_, _tmp8_);
		_tmp10_ = _tmp9_;
		_vala_code_node_unref0 (_tmp6_);
		_result_ = _tmp10_;
		_tmp11_ = _result_;
		_tmp12_ = self->priv->_params_array;
		vala_parameter_set_params_array (_tmp11_, _tmp12_);
		_tmp13_ = _result_;
		_tmp14_ = self->priv->_direction;
		vala_parameter_set_direction (_tmp13_, _tmp14_);
		_tmp15_ = _result_;
		_tmp16_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp17_ = _tmp16_;
		vala_variable_set_initializer ((ValaVariable*) _tmp15_, _tmp17_);
		_tmp18_ = ((ValaCodeNode*) self)->attributes;
		{
			GList* a_collection = NULL;
			GList* a_it = NULL;
			a_collection = _tmp18_;
			for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
				ValaAttribute* _tmp19_;
				ValaAttribute* a = NULL;
				_tmp19_ = _vala_code_node_ref0 ((ValaAttribute*) a_it->data);
				a = _tmp19_;
				{
					ValaParameter* _tmp20_;
					ValaAttribute* _tmp21_;
					ValaAttribute* _tmp22_;
					_tmp20_ = _result_;
					_tmp21_ = a;
					_tmp22_ = _vala_code_node_ref0 (_tmp21_);
					((ValaCodeNode*) _tmp20_)->attributes = g_list_append (((ValaCodeNode*) _tmp20_)->attributes, _tmp22_);
					_vala_code_node_unref0 (a);
				}
			}
		}
		result = _result_;
		return result;
	} else {
		ValaParameter* _tmp23_;
		_tmp23_ = vala_parameter_new_with_ellipsis (NULL);
		result = _tmp23_;
		return result;
	}
}


static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}


static gboolean
vala_parameter_real_check (ValaCodeNode* base,
                           ValaCodeContext* context)
{
	ValaParameter * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaSymbol* _tmp24_;
	ValaSymbol* _tmp25_;
	ValaDataType* _tmp26_;
	ValaDataType* _tmp27_;
	gboolean _tmp34_;
	gboolean _tmp75_ = FALSE;
	ValaExpression* _tmp76_;
	ValaExpression* _tmp77_;
	gboolean _tmp144_;
	ValaMethod* m = NULL;
	ValaSymbol* _tmp183_;
	ValaSymbol* _tmp184_;
	ValaMethod* _tmp185_;
	ValaMethod* _tmp186_;
	ValaSemanticAnalyzer* _tmp221_;
	ValaSemanticAnalyzer* _tmp222_;
	ValaSourceFile* _tmp223_;
	ValaSemanticAnalyzer* _tmp224_;
	ValaSemanticAnalyzer* _tmp225_;
	ValaSymbol* _tmp226_;
	gboolean _tmp227_;
	gboolean _tmp228_;
	self = (ValaParameter*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	_tmp24_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp25_ = _tmp24_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, _tmp25_);
	_tmp26_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp27_ = _tmp26_;
	if (_tmp27_ != NULL) {
		ValaDataType* _tmp28_;
		ValaDataType* _tmp29_;
		ValaDataType* _tmp32_;
		ValaDataType* _tmp33_;
		_tmp28_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp29_ = _tmp28_;
		if (VALA_IS_VOID_TYPE (_tmp29_)) {
			ValaSourceReference* _tmp30_;
			ValaSourceReference* _tmp31_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp30_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp31_ = _tmp30_;
			vala_report_error (_tmp31_, "'void' not supported as parameter type");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp32_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp33_ = _tmp32_;
		vala_code_node_check ((ValaCodeNode*) _tmp33_, context);
	}
	_tmp34_ = self->priv->_ellipsis;
	if (!_tmp34_) {
		ValaDataType* _tmp35_;
		ValaDataType* _tmp36_;
		gboolean _tmp37_ = FALSE;
		gboolean _tmp38_;
		gboolean _tmp43_ = FALSE;
		ValaExpression* _tmp52_;
		ValaExpression* _tmp53_;
		ValaArrayType* variable_array_type = NULL;
		ValaDataType* _tmp62_;
		ValaDataType* _tmp63_;
		gboolean _tmp64_ = FALSE;
		gboolean _tmp65_ = FALSE;
		ValaArrayType* _tmp66_;
		_tmp35_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp36_ = _tmp35_;
		vala_code_node_check ((ValaCodeNode*) _tmp36_, context);
		_tmp38_ = self->priv->_params_array;
		if (_tmp38_) {
			ValaDataType* _tmp39_;
			ValaDataType* _tmp40_;
			_tmp39_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp40_ = _tmp39_;
			_tmp37_ = !VALA_IS_ARRAY_TYPE (_tmp40_);
		} else {
			_tmp37_ = FALSE;
		}
		if (_tmp37_) {
			ValaSourceReference* _tmp41_;
			ValaSourceReference* _tmp42_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp41_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp42_ = _tmp41_;
			vala_report_error (_tmp42_, "parameter array expected");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		if (vala_code_node_has_attribute_argument ((ValaCodeNode*) self, "CCode", "scope")) {
			ValaDataType* _tmp44_;
			ValaDataType* _tmp45_;
			_tmp44_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp45_ = _tmp44_;
			_tmp43_ = VALA_IS_DELEGATE_TYPE (_tmp45_);
		} else {
			_tmp43_ = FALSE;
		}
		if (_tmp43_) {
			ValaDelegateType* delegate_type = NULL;
			ValaDataType* _tmp46_;
			ValaDataType* _tmp47_;
			ValaDelegateType* _tmp48_;
			ValaDelegateType* _tmp49_;
			gchar* _tmp50_;
			gchar* _tmp51_;
			_tmp46_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp47_ = _tmp46_;
			_tmp48_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			delegate_type = _tmp48_;
			_tmp49_ = delegate_type;
			_tmp50_ = vala_code_node_get_attribute_string ((ValaCodeNode*) self, "CCode", "scope", NULL);
			_tmp51_ = _tmp50_;
			vala_delegate_type_set_is_called_once (_tmp49_, g_strcmp0 (_tmp51_, "async") == 0);
			_g_free0 (_tmp51_);
			_vala_code_node_unref0 (delegate_type);
		}
		_tmp52_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp53_ = _tmp52_;
		if (_tmp53_ != NULL) {
			ValaExpression* _tmp54_;
			ValaExpression* _tmp55_;
			ValaDataType* _tmp56_;
			ValaDataType* _tmp57_;
			ValaDataType* _tmp58_;
			ValaDataType* _tmp59_;
			ValaExpression* _tmp60_;
			ValaExpression* _tmp61_;
			_tmp54_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp55_ = _tmp54_;
			_tmp56_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp57_ = _tmp56_;
			_tmp58_ = vala_data_type_copy (_tmp57_);
			_tmp59_ = _tmp58_;
			vala_expression_set_target_type (_tmp55_, _tmp59_);
			_vala_code_node_unref0 (_tmp59_);
			_tmp60_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp61_ = _tmp60_;
			vala_code_node_check ((ValaCodeNode*) _tmp61_, context);
		}
		_tmp62_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp63_ = _tmp62_;
		variable_array_type = VALA_IS_ARRAY_TYPE (_tmp63_) ? ((ValaArrayType*) _tmp63_) : NULL;
		_tmp66_ = variable_array_type;
		if (_tmp66_ != NULL) {
			ValaArrayType* _tmp67_;
			gboolean _tmp68_;
			gboolean _tmp69_;
			_tmp67_ = variable_array_type;
			_tmp68_ = vala_array_type_get_inline_allocated (_tmp67_);
			_tmp69_ = _tmp68_;
			_tmp65_ = _tmp69_;
		} else {
			_tmp65_ = FALSE;
		}
		if (_tmp65_) {
			ValaArrayType* _tmp70_;
			gboolean _tmp71_;
			gboolean _tmp72_;
			_tmp70_ = variable_array_type;
			_tmp71_ = vala_array_type_get_fixed_length (_tmp70_);
			_tmp72_ = _tmp71_;
			_tmp64_ = !_tmp72_;
		} else {
			_tmp64_ = FALSE;
		}
		if (_tmp64_) {
			ValaSourceReference* _tmp73_;
			ValaSourceReference* _tmp74_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp73_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp74_ = _tmp73_;
			vala_report_error (_tmp74_, "Inline allocated array as parameter requires to have fixed length");
		}
	}
	_tmp76_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp77_ = _tmp76_;
	if (_tmp77_ != NULL) {
		ValaExpression* _tmp78_;
		ValaExpression* _tmp79_;
		gboolean _tmp80_;
		gboolean _tmp81_;
		_tmp78_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp79_ = _tmp78_;
		_tmp80_ = vala_code_node_get_error ((ValaCodeNode*) _tmp79_);
		_tmp81_ = _tmp80_;
		_tmp75_ = !_tmp81_;
	} else {
		_tmp75_ = FALSE;
	}
	if (_tmp75_) {
		gboolean _tmp82_ = FALSE;
		gboolean _tmp83_ = FALSE;
		ValaExpression* _tmp84_;
		ValaExpression* _tmp85_;
		_tmp84_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp85_ = _tmp84_;
		if (VALA_IS_NULL_LITERAL (_tmp85_)) {
			ValaDataType* _tmp86_;
			ValaDataType* _tmp87_;
			gboolean _tmp88_;
			gboolean _tmp89_;
			_tmp86_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp87_ = _tmp86_;
			_tmp88_ = vala_data_type_get_nullable (_tmp87_);
			_tmp89_ = _tmp88_;
			_tmp83_ = !_tmp89_;
		} else {
			_tmp83_ = FALSE;
		}
		if (_tmp83_) {
			ValaParameterDirection _tmp90_;
			_tmp90_ = self->priv->_direction;
			_tmp82_ = _tmp90_ != VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp82_ = FALSE;
		}
		if (_tmp82_) {
			ValaSourceReference* _tmp91_;
			ValaSourceReference* _tmp92_;
			ValaDataType* _tmp93_;
			ValaDataType* _tmp94_;
			gchar* _tmp95_;
			gchar* _tmp96_;
			gchar* _tmp97_;
			gchar* _tmp98_;
			_tmp91_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp92_ = _tmp91_;
			_tmp93_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp94_ = _tmp93_;
			_tmp95_ = vala_code_node_to_string ((ValaCodeNode*) _tmp94_);
			_tmp96_ = _tmp95_;
			_tmp97_ = g_strdup_printf ("`null' incompatible with parameter type `%s`", _tmp96_);
			_tmp98_ = _tmp97_;
			vala_report_warning (_tmp92_, _tmp98_);
			_g_free0 (_tmp98_);
			_g_free0 (_tmp96_);
		} else {
			gboolean _tmp99_ = FALSE;
			ValaExpression* _tmp100_;
			ValaExpression* _tmp101_;
			_tmp100_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp101_ = _tmp100_;
			if (!VALA_IS_NULL_LITERAL (_tmp101_)) {
				ValaParameterDirection _tmp102_;
				_tmp102_ = self->priv->_direction;
				_tmp99_ = _tmp102_ == VALA_PARAMETER_DIRECTION_OUT;
			} else {
				_tmp99_ = FALSE;
			}
			if (_tmp99_) {
				ValaSourceReference* _tmp103_;
				ValaSourceReference* _tmp104_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp103_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp104_ = _tmp103_;
				vala_report_error (_tmp104_, "only `null' is allowed as default value for out parameters");
			} else {
				gboolean _tmp105_ = FALSE;
				ValaParameterDirection _tmp106_;
				_tmp106_ = self->priv->_direction;
				if (_tmp106_ == VALA_PARAMETER_DIRECTION_IN) {
					ValaExpression* _tmp107_;
					ValaExpression* _tmp108_;
					ValaDataType* _tmp109_;
					ValaDataType* _tmp110_;
					ValaDataType* _tmp111_;
					ValaDataType* _tmp112_;
					_tmp107_ = vala_variable_get_initializer ((ValaVariable*) self);
					_tmp108_ = _tmp107_;
					_tmp109_ = vala_expression_get_value_type (_tmp108_);
					_tmp110_ = _tmp109_;
					_tmp111_ = vala_variable_get_variable_type ((ValaVariable*) self);
					_tmp112_ = _tmp111_;
					_tmp105_ = !vala_data_type_compatible (_tmp110_, _tmp112_);
				} else {
					_tmp105_ = FALSE;
				}
				if (_tmp105_) {
					ValaExpression* _tmp113_;
					ValaExpression* _tmp114_;
					ValaSourceReference* _tmp115_;
					ValaSourceReference* _tmp116_;
					ValaExpression* _tmp117_;
					ValaExpression* _tmp118_;
					ValaDataType* _tmp119_;
					ValaDataType* _tmp120_;
					gchar* _tmp121_;
					gchar* _tmp122_;
					ValaDataType* _tmp123_;
					ValaDataType* _tmp124_;
					gchar* _tmp125_;
					gchar* _tmp126_;
					gchar* _tmp127_;
					gchar* _tmp128_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp113_ = vala_variable_get_initializer ((ValaVariable*) self);
					_tmp114_ = _tmp113_;
					_tmp115_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp114_);
					_tmp116_ = _tmp115_;
					_tmp117_ = vala_variable_get_initializer ((ValaVariable*) self);
					_tmp118_ = _tmp117_;
					_tmp119_ = vala_expression_get_value_type (_tmp118_);
					_tmp120_ = _tmp119_;
					_tmp121_ = vala_code_node_to_string ((ValaCodeNode*) _tmp120_);
					_tmp122_ = _tmp121_;
					_tmp123_ = vala_variable_get_variable_type ((ValaVariable*) self);
					_tmp124_ = _tmp123_;
					_tmp125_ = vala_code_node_to_string ((ValaCodeNode*) _tmp124_);
					_tmp126_ = _tmp125_;
					_tmp127_ = g_strdup_printf ("Cannot convert from `%s' to `%s'", _tmp122_, _tmp126_);
					_tmp128_ = _tmp127_;
					vala_report_error (_tmp116_, _tmp128_);
					_g_free0 (_tmp128_);
					_g_free0 (_tmp126_);
					_g_free0 (_tmp122_);
				} else {
					ValaParameterDirection _tmp129_;
					_tmp129_ = self->priv->_direction;
					if (_tmp129_ == VALA_PARAMETER_DIRECTION_REF) {
						ValaSourceReference* _tmp130_;
						ValaSourceReference* _tmp131_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp130_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp131_ = _tmp130_;
						vala_report_error (_tmp131_, "default value not allowed for ref parameter");
					} else {
						ValaExpression* _tmp132_;
						ValaExpression* _tmp133_;
						_tmp132_ = vala_variable_get_initializer ((ValaVariable*) self);
						_tmp133_ = _tmp132_;
						if (!vala_expression_is_accessible (_tmp133_, (ValaSymbol*) self)) {
							ValaExpression* _tmp134_;
							ValaExpression* _tmp135_;
							ValaSourceReference* _tmp136_;
							ValaSourceReference* _tmp137_;
							ValaSymbol* _tmp138_;
							ValaSymbol* _tmp139_;
							gchar* _tmp140_;
							gchar* _tmp141_;
							gchar* _tmp142_;
							gchar* _tmp143_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp134_ = vala_variable_get_initializer ((ValaVariable*) self);
							_tmp135_ = _tmp134_;
							_tmp136_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp135_);
							_tmp137_ = _tmp136_;
							_tmp138_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
							_tmp139_ = _tmp138_;
							_tmp140_ = vala_symbol_get_full_name (_tmp139_);
							_tmp141_ = _tmp140_;
							_tmp142_ = g_strdup_printf ("default value is less accessible than method `%s'", _tmp141_);
							_tmp143_ = _tmp142_;
							vala_report_error (_tmp137_, _tmp143_);
							_g_free0 (_tmp143_);
							_g_free0 (_tmp141_);
						}
					}
				}
			}
		}
	}
	_tmp144_ = self->priv->_ellipsis;
	if (!_tmp144_) {
		gboolean _tmp145_;
		gboolean _tmp146_;
		ValaSemanticAnalyzer* _tmp167_;
		ValaSemanticAnalyzer* _tmp168_;
		ValaDataType* _tmp169_;
		ValaDataType* _tmp170_;
		_tmp145_ = vala_symbol_get_external_package ((ValaSymbol*) self);
		_tmp146_ = _tmp145_;
		if (!_tmp146_) {
			gboolean _tmp147_ = FALSE;
			gboolean _tmp148_ = FALSE;
			ValaSymbol* _tmp149_;
			ValaSymbol* _tmp150_;
			_tmp149_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp150_ = _tmp149_;
			if (_tmp150_ == NULL) {
				_tmp148_ = TRUE;
			} else {
				ValaSymbol* _tmp151_;
				ValaSymbol* _tmp152_;
				gboolean _tmp153_;
				gboolean _tmp154_;
				_tmp151_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp152_ = _tmp151_;
				_tmp153_ = vala_symbol_get_external_package (_tmp152_);
				_tmp154_ = _tmp153_;
				_tmp148_ = !_tmp154_;
			}
			if (_tmp148_) {
				ValaDataType* _tmp155_;
				ValaDataType* _tmp156_;
				ValaTypeSymbol* _tmp157_;
				ValaTypeSymbol* _tmp158_;
				_tmp155_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp156_ = _tmp155_;
				_tmp157_ = vala_data_type_get_data_type (_tmp156_);
				_tmp158_ = _tmp157_;
				_tmp147_ = _tmp158_ != NULL;
			} else {
				_tmp147_ = FALSE;
			}
			if (_tmp147_) {
				ValaDataType* _tmp159_;
				ValaDataType* _tmp160_;
				ValaTypeSymbol* _tmp161_;
				ValaTypeSymbol* _tmp162_;
				ValaVersionAttribute* _tmp163_;
				ValaVersionAttribute* _tmp164_;
				ValaSourceReference* _tmp165_;
				ValaSourceReference* _tmp166_;
				_tmp159_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp160_ = _tmp159_;
				_tmp161_ = vala_data_type_get_data_type (_tmp160_);
				_tmp162_ = _tmp161_;
				_tmp163_ = vala_symbol_get_version ((ValaSymbol*) _tmp162_);
				_tmp164_ = _tmp163_;
				_tmp165_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp166_ = _tmp165_;
				vala_version_attribute_check (_tmp164_, _tmp166_);
			}
		}
		_tmp167_ = vala_code_context_get_analyzer (context);
		_tmp168_ = _tmp167_;
		_tmp169_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp170_ = _tmp169_;
		if (!vala_semantic_analyzer_is_type_accessible (_tmp168_, (ValaSymbol*) self, _tmp170_)) {
			ValaSourceReference* _tmp171_;
			ValaSourceReference* _tmp172_;
			ValaDataType* _tmp173_;
			ValaDataType* _tmp174_;
			gchar* _tmp175_;
			gchar* _tmp176_;
			ValaSymbol* _tmp177_;
			ValaSymbol* _tmp178_;
			gchar* _tmp179_;
			gchar* _tmp180_;
			gchar* _tmp181_;
			gchar* _tmp182_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp171_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp172_ = _tmp171_;
			_tmp173_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp174_ = _tmp173_;
			_tmp175_ = vala_code_node_to_string ((ValaCodeNode*) _tmp174_);
			_tmp176_ = _tmp175_;
			_tmp177_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp178_ = _tmp177_;
			_tmp179_ = vala_symbol_get_full_name (_tmp178_);
			_tmp180_ = _tmp179_;
			_tmp181_ = g_strdup_printf ("parameter type `%s` is less accessible than method `%s`", _tmp176_, _tmp180_);
			_tmp182_ = _tmp181_;
			vala_report_error (_tmp172_, _tmp182_);
			_g_free0 (_tmp182_);
			_g_free0 (_tmp180_);
			_g_free0 (_tmp176_);
		}
	}
	_tmp183_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp184_ = _tmp183_;
	_tmp185_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp184_) ? ((ValaMethod*) _tmp184_) : NULL);
	m = _tmp185_;
	_tmp186_ = m;
	if (_tmp186_ != NULL) {
		ValaMethod* base_method = NULL;
		gboolean _tmp187_ = FALSE;
		ValaMethod* _tmp188_;
		ValaMethod* _tmp189_;
		ValaMethod* _tmp190_;
		ValaMethod* _tmp209_;
		base_method = NULL;
		_tmp188_ = m;
		_tmp189_ = vala_method_get_base_method (_tmp188_);
		_tmp190_ = _tmp189_;
		if (_tmp190_ != NULL) {
			ValaMethod* _tmp191_;
			ValaMethod* _tmp192_;
			ValaMethod* _tmp193_;
			ValaMethod* _tmp194_;
			_tmp191_ = m;
			_tmp192_ = vala_method_get_base_method (_tmp191_);
			_tmp193_ = _tmp192_;
			_tmp194_ = m;
			_tmp187_ = _tmp193_ != _tmp194_;
		} else {
			_tmp187_ = FALSE;
		}
		if (_tmp187_) {
			ValaMethod* _tmp195_;
			ValaMethod* _tmp196_;
			ValaMethod* _tmp197_;
			_tmp195_ = m;
			_tmp196_ = vala_method_get_base_method (_tmp195_);
			_tmp197_ = _tmp196_;
			base_method = _tmp197_;
		} else {
			gboolean _tmp198_ = FALSE;
			ValaMethod* _tmp199_;
			ValaMethod* _tmp200_;
			ValaMethod* _tmp201_;
			_tmp199_ = m;
			_tmp200_ = vala_method_get_base_interface_method (_tmp199_);
			_tmp201_ = _tmp200_;
			if (_tmp201_ != NULL) {
				ValaMethod* _tmp202_;
				ValaMethod* _tmp203_;
				ValaMethod* _tmp204_;
				ValaMethod* _tmp205_;
				_tmp202_ = m;
				_tmp203_ = vala_method_get_base_interface_method (_tmp202_);
				_tmp204_ = _tmp203_;
				_tmp205_ = m;
				_tmp198_ = _tmp204_ != _tmp205_;
			} else {
				_tmp198_ = FALSE;
			}
			if (_tmp198_) {
				ValaMethod* _tmp206_;
				ValaMethod* _tmp207_;
				ValaMethod* _tmp208_;
				_tmp206_ = m;
				_tmp207_ = vala_method_get_base_interface_method (_tmp206_);
				_tmp208_ = _tmp207_;
				base_method = _tmp208_;
			}
		}
		_tmp209_ = base_method;
		if (_tmp209_ != NULL) {
			gint index = 0;
			ValaMethod* _tmp210_;
			ValaList* _tmp211_;
			ValaList* _tmp212_;
			gint _tmp213_;
			gint _tmp214_;
			_tmp210_ = m;
			_tmp211_ = vala_callable_get_parameters ((ValaCallable*) _tmp210_);
			_tmp212_ = _tmp211_;
			_tmp213_ = vala_list_index_of (_tmp212_, self);
			_vala_iterable_unref0 (_tmp212_);
			index = _tmp213_;
			_tmp214_ = index;
			if (_tmp214_ >= 0) {
				ValaMethod* _tmp215_;
				ValaList* _tmp216_;
				ValaList* _tmp217_;
				gint _tmp218_;
				gpointer _tmp219_;
				ValaParameter* _tmp220_;
				_tmp215_ = base_method;
				_tmp216_ = vala_callable_get_parameters ((ValaCallable*) _tmp215_);
				_tmp217_ = _tmp216_;
				_tmp218_ = index;
				_tmp219_ = vala_list_get (_tmp217_, _tmp218_);
				_tmp220_ = (ValaParameter*) _tmp219_;
				vala_parameter_set_base_parameter (self, _tmp220_);
				_vala_code_node_unref0 (_tmp220_);
				_vala_iterable_unref0 (_tmp217_);
			}
		}
	}
	_tmp221_ = vala_code_context_get_analyzer (context);
	_tmp222_ = _tmp221_;
	_tmp223_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp222_, _tmp223_);
	_tmp224_ = vala_code_context_get_analyzer (context);
	_tmp225_ = _tmp224_;
	_tmp226_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp225_, _tmp226_);
	_tmp227_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp228_ = _tmp227_;
	result = !_tmp228_;
	_vala_code_node_unref0 (m);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


ValaParameterDirection
vala_parameter_get_direction (ValaParameter* self)
{
	ValaParameterDirection result;
	ValaParameterDirection _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_direction;
	result = _tmp0_;
	return result;
}


void
vala_parameter_set_direction (ValaParameter* self,
                              ValaParameterDirection value)
{
	g_return_if_fail (self != NULL);
	self->priv->_direction = value;
}


gboolean
vala_parameter_get_ellipsis (ValaParameter* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_ellipsis;
	result = _tmp0_;
	return result;
}


void
vala_parameter_set_ellipsis (ValaParameter* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_ellipsis = value;
}


gboolean
vala_parameter_get_params_array (ValaParameter* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_params_array;
	result = _tmp0_;
	return result;
}


void
vala_parameter_set_params_array (ValaParameter* self,
                                 gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_params_array = value;
}


gboolean
vala_parameter_get_captured (ValaParameter* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_captured;
	result = _tmp0_;
	return result;
}


void
vala_parameter_set_captured (ValaParameter* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_captured = value;
}


gboolean
vala_parameter_get_format_arg (ValaParameter* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "FormatArg");
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_vala_code_node_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}


ValaParameter*
vala_parameter_get_base_parameter (ValaParameter* self)
{
	ValaParameter* result;
	ValaParameter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_parameter;
	result = _tmp0_;
	return result;
}


void
vala_parameter_set_base_parameter (ValaParameter* self,
                                   ValaParameter* value)
{
	ValaParameter* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_base_parameter);
	self->priv->_base_parameter = _tmp0_;
}


static void
vala_parameter_class_init (ValaParameterClass * klass)
{
	vala_parameter_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_parameter_finalize;
	g_type_class_add_private (klass, sizeof (ValaParameterPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_parameter_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_parameter_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_parameter_real_replace_type;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_parameter_real_replace_expression;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_parameter_real_check;
}


static void
vala_parameter_instance_init (ValaParameter * self)
{
	self->priv = VALA_PARAMETER_GET_PRIVATE (self);
	self->priv->_direction = VALA_PARAMETER_DIRECTION_IN;
}


static void
vala_parameter_finalize (ValaCodeNode * obj)
{
	ValaParameter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_PARAMETER, ValaParameter);
	_vala_code_node_unref0 (self->priv->_base_parameter);
	VALA_CODE_NODE_CLASS (vala_parameter_parent_class)->finalize (obj);
}


/**
 * Represents a formal parameter in method and callback signatures.
 */
GType
vala_parameter_get_type (void)
{
	static volatile gsize vala_parameter_type_id__volatile = 0;
	if (g_once_init_enter (&vala_parameter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaParameterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_parameter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaParameter), 0, (GInstanceInitFunc) vala_parameter_instance_init, NULL };
		GType vala_parameter_type_id;
		vala_parameter_type_id = g_type_register_static (VALA_TYPE_VARIABLE, "ValaParameter", &g_define_type_info, 0);
		g_once_init_leave (&vala_parameter_type_id__volatile, vala_parameter_type_id);
	}
	return vala_parameter_type_id__volatile;
}


GType
vala_parameter_direction_get_type (void)
{
	static volatile gsize vala_parameter_direction_type_id__volatile = 0;
	if (g_once_init_enter (&vala_parameter_direction_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_PARAMETER_DIRECTION_IN, "VALA_PARAMETER_DIRECTION_IN", "in"}, {VALA_PARAMETER_DIRECTION_OUT, "VALA_PARAMETER_DIRECTION_OUT", "out"}, {VALA_PARAMETER_DIRECTION_REF, "VALA_PARAMETER_DIRECTION_REF", "ref"}, {0, NULL, NULL}};
		GType vala_parameter_direction_type_id;
		vala_parameter_direction_type_id = g_enum_register_static ("ValaParameterDirection", values);
		g_once_init_leave (&vala_parameter_direction_type_id__volatile, vala_parameter_direction_type_id);
	}
	return vala_parameter_direction_type_id__volatile;
}



