/* valafield.c generated by valac, the Vala compiler
 * generated from valafield.vala, do not modify */

/* valafield.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaFieldPrivate {
	ValaMemberBinding _binding;
	gboolean _is_volatile;
	gboolean lock_used;
};


static gpointer vala_field_parent_class = NULL;
static ValaLockableIface * vala_field_vala_lockable_parent_iface = NULL;

#define VALA_FIELD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_FIELD, ValaFieldPrivate))
static void vala_field_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor);
static void vala_field_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static gboolean vala_field_real_get_lock_used (ValaLockable* base);
static void vala_field_real_set_lock_used (ValaLockable* base,
                                    gboolean used);
static void vala_field_real_replace_expression (ValaCodeNode* base,
                                         ValaExpression* old_node,
                                         ValaExpression* new_node);
static void vala_field_real_replace_type (ValaCodeNode* base,
                                   ValaDataType* old_type,
                                   ValaDataType* new_type);
static gboolean vala_field_real_check (ValaCodeNode* base,
                                ValaCodeContext* context);
static void vala_field_finalize (ValaCodeNode * obj);


/**
 * Creates a new field.
 *
 * @param name              field name
 * @param variable_type     field type
 * @param initializer       initializer expression
 * @param source_reference  reference to source code
 * @return                  newly created field
 */
ValaField*
vala_field_construct (GType object_type,
                      const gchar* name,
                      ValaDataType* variable_type,
                      ValaExpression* initializer,
                      ValaSourceReference* source_reference,
                      ValaComment* comment)
{
	ValaField* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (variable_type != NULL, NULL);
	self = (ValaField*) vala_variable_construct (object_type, variable_type, name, initializer, source_reference, comment);
	return self;
}


ValaField*
vala_field_new (const gchar* name,
                ValaDataType* variable_type,
                ValaExpression* initializer,
                ValaSourceReference* source_reference,
                ValaComment* comment)
{
	return vala_field_construct (VALA_TYPE_FIELD, name, variable_type, initializer, source_reference, comment);
}


static void
vala_field_real_accept (ValaCodeNode* base,
                        ValaCodeVisitor* visitor)
{
	ValaField * self;
	self = (ValaField*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_field (visitor, self);
}


static void
vala_field_real_accept_children (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaField * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaField*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp5_ = _tmp4_;
		vala_code_node_accept ((ValaCodeNode*) _tmp5_, visitor);
	}
}


static gboolean
vala_field_real_get_lock_used (ValaLockable* base)
{
	ValaField * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (ValaField*) base;
	_tmp0_ = self->priv->lock_used;
	result = _tmp0_;
	return result;
}


static void
vala_field_real_set_lock_used (ValaLockable* base,
                               gboolean used)
{
	ValaField * self;
	self = (ValaField*) base;
	self->priv->lock_used = used;
}


static void
vala_field_real_replace_expression (ValaCodeNode* base,
                                    ValaExpression* old_node,
                                    ValaExpression* new_node)
{
	ValaField * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaField*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_variable_set_initializer ((ValaVariable*) self, new_node);
	}
}


static void
vala_field_real_replace_type (ValaCodeNode* base,
                              ValaDataType* old_type,
                              ValaDataType* new_type)
{
	ValaField * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaField*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_variable_set_variable_type ((ValaVariable*) self, new_type);
	}
}


static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_field_real_check (ValaCodeNode* base,
                       ValaCodeContext* context)
{
	ValaField * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaDataType* _tmp24_;
	ValaDataType* _tmp25_;
	ValaDataType* _tmp28_;
	ValaDataType* _tmp29_;
	ValaSemanticAnalyzer* _tmp30_;
	ValaSemanticAnalyzer* _tmp31_;
	ValaDataType* _tmp32_;
	ValaDataType* _tmp33_;
	ValaExpression* _tmp44_;
	ValaExpression* _tmp45_;
	gboolean _tmp133_ = FALSE;
	ValaMemberBinding _tmp134_;
	gboolean field_in_header = FALSE;
	ValaSymbol* _tmp139_;
	ValaSymbol* _tmp140_;
	gboolean _tmp149_ = FALSE;
	gboolean _tmp150_ = FALSE;
	gboolean _tmp151_;
	gboolean _tmp152_;
	ValaSemanticAnalyzer* _tmp167_;
	ValaSemanticAnalyzer* _tmp168_;
	ValaSourceFile* _tmp169_;
	ValaSemanticAnalyzer* _tmp170_;
	ValaSemanticAnalyzer* _tmp171_;
	ValaSymbol* _tmp172_;
	gboolean _tmp173_;
	gboolean _tmp174_;
	self = (ValaField*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	_tmp24_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp25_ = _tmp24_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, VALA_TYPE_VOID_TYPE)) {
		ValaSourceReference* _tmp26_;
		ValaSourceReference* _tmp27_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp27_ = _tmp26_;
		vala_report_error (_tmp27_, "'void' not supported as field type");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp28_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp29_ = _tmp28_;
	vala_code_node_check ((ValaCodeNode*) _tmp29_, context);
	_tmp30_ = vala_code_context_get_analyzer (context);
	_tmp31_ = _tmp30_;
	_tmp32_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp33_ = _tmp32_;
	if (!vala_semantic_analyzer_is_type_accessible (_tmp31_, (ValaSymbol*) self, _tmp33_)) {
		ValaSourceReference* _tmp34_;
		ValaSourceReference* _tmp35_;
		ValaDataType* _tmp36_;
		ValaDataType* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp34_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_code_node_to_string ((ValaCodeNode*) _tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp41_ = _tmp40_;
		_tmp42_ = g_strdup_printf ("field type `%s` is less accessible than field `%s`", _tmp39_, _tmp41_);
		_tmp43_ = _tmp42_;
		vala_report_error (_tmp35_, _tmp43_);
		_g_free0 (_tmp43_);
		_g_free0 (_tmp41_);
		_g_free0 (_tmp39_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp44_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp45_ = _tmp44_;
	if (_tmp45_ != NULL) {
		ValaExpression* _tmp46_;
		ValaExpression* _tmp47_;
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		ValaExpression* _tmp50_;
		ValaExpression* _tmp51_;
		ValaExpression* _tmp52_;
		ValaExpression* _tmp53_;
		ValaDataType* _tmp54_;
		ValaDataType* _tmp55_;
		ValaExpression* _tmp58_;
		ValaExpression* _tmp59_;
		ValaDataType* _tmp60_;
		ValaDataType* _tmp61_;
		ValaDataType* _tmp62_;
		ValaDataType* _tmp63_;
		ValaExpression* _tmp78_;
		ValaExpression* _tmp79_;
		ValaDataType* _tmp80_;
		ValaDataType* _tmp81_;
		gboolean _tmp91_ = FALSE;
		ValaSymbol* _tmp92_;
		ValaSymbol* _tmp93_;
		gboolean _tmp98_ = FALSE;
		gboolean _tmp99_ = FALSE;
		ValaSymbol* _tmp100_;
		ValaSymbol* _tmp101_;
		gboolean _tmp115_ = FALSE;
		gboolean _tmp116_ = FALSE;
		gboolean _tmp117_ = FALSE;
		ValaMemberBinding _tmp118_;
		gboolean _tmp129_;
		gboolean _tmp130_;
		_tmp46_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp49_ = _tmp48_;
		vala_expression_set_target_type (_tmp47_, _tmp49_);
		_tmp50_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp51_ = _tmp50_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp51_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp52_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp53_ = _tmp52_;
		_tmp54_ = vala_expression_get_value_type (_tmp53_);
		_tmp55_ = _tmp54_;
		if (_tmp55_ == NULL) {
			ValaSourceReference* _tmp56_;
			ValaSourceReference* _tmp57_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp56_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp57_ = _tmp56_;
			vala_report_error (_tmp57_, "expression type not allowed as initializer");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp58_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp59_ = _tmp58_;
		_tmp60_ = vala_expression_get_value_type (_tmp59_);
		_tmp61_ = _tmp60_;
		_tmp62_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp63_ = _tmp62_;
		if (!vala_data_type_compatible (_tmp61_, _tmp63_)) {
			ValaSourceReference* _tmp64_;
			ValaSourceReference* _tmp65_;
			ValaExpression* _tmp66_;
			ValaExpression* _tmp67_;
			ValaDataType* _tmp68_;
			ValaDataType* _tmp69_;
			gchar* _tmp70_;
			gchar* _tmp71_;
			ValaDataType* _tmp72_;
			ValaDataType* _tmp73_;
			gchar* _tmp74_;
			gchar* _tmp75_;
			gchar* _tmp76_;
			gchar* _tmp77_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp64_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp65_ = _tmp64_;
			_tmp66_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp67_ = _tmp66_;
			_tmp68_ = vala_expression_get_value_type (_tmp67_);
			_tmp69_ = _tmp68_;
			_tmp70_ = vala_code_node_to_string ((ValaCodeNode*) _tmp69_);
			_tmp71_ = _tmp70_;
			_tmp72_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp73_ = _tmp72_;
			_tmp74_ = vala_code_node_to_string ((ValaCodeNode*) _tmp73_);
			_tmp75_ = _tmp74_;
			_tmp76_ = g_strdup_printf ("Cannot convert from `%s' to `%s'", _tmp71_, _tmp75_);
			_tmp77_ = _tmp76_;
			vala_report_error (_tmp65_, _tmp77_);
			_g_free0 (_tmp77_);
			_g_free0 (_tmp75_);
			_g_free0 (_tmp71_);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp78_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp79_ = _tmp78_;
		_tmp80_ = vala_expression_get_value_type (_tmp79_);
		_tmp81_ = _tmp80_;
		if (vala_data_type_is_disposable (_tmp81_)) {
			gboolean _tmp82_ = FALSE;
			ValaDataType* _tmp83_;
			ValaDataType* _tmp84_;
			_tmp83_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp84_ = _tmp83_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp84_, VALA_TYPE_POINTER_TYPE)) {
				ValaDataType* _tmp85_;
				ValaDataType* _tmp86_;
				gboolean _tmp87_;
				gboolean _tmp88_;
				_tmp85_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp86_ = _tmp85_;
				_tmp87_ = vala_data_type_get_value_owned (_tmp86_);
				_tmp88_ = _tmp87_;
				_tmp82_ = !_tmp88_;
			} else {
				_tmp82_ = FALSE;
			}
			if (_tmp82_) {
				ValaSourceReference* _tmp89_;
				ValaSourceReference* _tmp90_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp89_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp90_ = _tmp89_;
				vala_report_error (_tmp90_, "Invalid assignment from owned expression to unowned variable");
				result = FALSE;
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
		}
		_tmp92_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp93_ = _tmp92_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp93_, VALA_TYPE_NAMESPACE)) {
			ValaExpression* _tmp94_;
			ValaExpression* _tmp95_;
			_tmp94_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp95_ = _tmp94_;
			_tmp91_ = !vala_expression_is_constant (_tmp95_);
		} else {
			_tmp91_ = FALSE;
		}
		if (_tmp91_) {
			ValaSourceReference* _tmp96_;
			ValaSourceReference* _tmp97_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp96_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp97_ = _tmp96_;
			vala_report_error (_tmp97_, "Non-constant field initializers not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp100_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp101_ = _tmp100_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp101_, VALA_TYPE_NAMESPACE)) {
			ValaExpression* _tmp102_;
			ValaExpression* _tmp103_;
			_tmp102_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp103_ = _tmp102_;
			_tmp99_ = vala_expression_is_constant (_tmp103_);
		} else {
			_tmp99_ = FALSE;
		}
		if (_tmp99_) {
			ValaExpression* _tmp104_;
			ValaExpression* _tmp105_;
			_tmp104_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp105_ = _tmp104_;
			_tmp98_ = vala_expression_is_non_null (_tmp105_);
		} else {
			_tmp98_ = FALSE;
		}
		if (_tmp98_) {
			gboolean _tmp106_ = FALSE;
			ValaDataType* _tmp107_;
			ValaDataType* _tmp108_;
			_tmp107_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp108_ = _tmp107_;
			if (vala_data_type_is_disposable (_tmp108_)) {
				ValaDataType* _tmp109_;
				ValaDataType* _tmp110_;
				gboolean _tmp111_;
				gboolean _tmp112_;
				_tmp109_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp110_ = _tmp109_;
				_tmp111_ = vala_data_type_get_value_owned (_tmp110_);
				_tmp112_ = _tmp111_;
				_tmp106_ = _tmp112_;
			} else {
				_tmp106_ = FALSE;
			}
			if (_tmp106_) {
				ValaSourceReference* _tmp113_;
				ValaSourceReference* _tmp114_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp113_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp114_ = _tmp113_;
				vala_report_error (_tmp114_, "Owned namespace fields can only be initialized in a function or method");
				result = FALSE;
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
		}
		_tmp118_ = self->priv->_binding;
		if (_tmp118_ == VALA_MEMBER_BINDING_STATIC) {
			ValaSymbol* _tmp119_;
			ValaSymbol* _tmp120_;
			_tmp119_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp120_ = _tmp119_;
			_tmp117_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp120_, VALA_TYPE_CLASS);
		} else {
			_tmp117_ = FALSE;
		}
		if (_tmp117_) {
			ValaSymbol* _tmp121_;
			ValaSymbol* _tmp122_;
			gboolean _tmp123_;
			gboolean _tmp124_;
			_tmp121_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp122_ = _tmp121_;
			_tmp123_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp122_, VALA_TYPE_CLASS, ValaClass));
			_tmp124_ = _tmp123_;
			_tmp116_ = _tmp124_;
		} else {
			_tmp116_ = FALSE;
		}
		if (_tmp116_) {
			ValaExpression* _tmp125_;
			ValaExpression* _tmp126_;
			_tmp125_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp126_ = _tmp125_;
			_tmp115_ = !vala_expression_is_constant (_tmp126_);
		} else {
			_tmp115_ = FALSE;
		}
		if (_tmp115_) {
			ValaSourceReference* _tmp127_;
			ValaSourceReference* _tmp128_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp127_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp128_ = _tmp127_;
			vala_report_error (_tmp128_, "Static fields in compact classes cannot have non-constant initializers");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp129_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp130_ = _tmp129_;
		if (_tmp130_) {
			ValaSourceReference* _tmp131_;
			ValaSourceReference* _tmp132_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp131_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp132_ = _tmp131_;
			vala_report_error (_tmp132_, "External fields cannot use initializers");
		}
	}
	_tmp134_ = self->priv->_binding;
	if (_tmp134_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaSymbol* _tmp135_;
		ValaSymbol* _tmp136_;
		_tmp135_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp136_ = _tmp135_;
		_tmp133_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp136_, VALA_TYPE_INTERFACE);
	} else {
		_tmp133_ = FALSE;
	}
	if (_tmp133_) {
		ValaSourceReference* _tmp137_;
		ValaSourceReference* _tmp138_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp137_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp138_ = _tmp137_;
		vala_report_error (_tmp138_, "Interfaces may not have instance fields");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	field_in_header = !vala_symbol_is_internal_symbol ((ValaSymbol*) self);
	_tmp139_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp140_ = _tmp139_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp140_, VALA_TYPE_CLASS)) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp141_;
		ValaSymbol* _tmp142_;
		ValaClass* _tmp143_;
		gboolean _tmp144_ = FALSE;
		ValaClass* _tmp145_;
		gboolean _tmp146_;
		gboolean _tmp147_;
		_tmp141_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp142_ = _tmp141_;
		_tmp143_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp142_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp143_;
		_tmp145_ = cl;
		_tmp146_ = vala_class_get_is_compact (_tmp145_);
		_tmp147_ = _tmp146_;
		if (_tmp147_) {
			ValaClass* _tmp148_;
			_tmp148_ = cl;
			_tmp144_ = !vala_symbol_is_internal_symbol ((ValaSymbol*) _tmp148_);
		} else {
			_tmp144_ = FALSE;
		}
		if (_tmp144_) {
			field_in_header = TRUE;
		}
		_vala_code_node_unref0 (cl);
	}
	_tmp151_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp152_ = _tmp151_;
	if (!_tmp152_) {
		gboolean _tmp153_;
		gboolean _tmp154_;
		_tmp153_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp154_ = _tmp153_;
		_tmp150_ = !_tmp154_;
	} else {
		_tmp150_ = FALSE;
	}
	if (_tmp150_) {
		ValaSymbol* _tmp155_;
		ValaSymbol* _tmp156_;
		_tmp155_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp156_ = _tmp155_;
		_tmp149_ = _tmp156_ != NULL;
		_vala_code_node_unref0 (_tmp156_);
	} else {
		_tmp149_ = FALSE;
	}
	if (_tmp149_) {
		ValaSourceReference* _tmp157_;
		ValaSourceReference* _tmp158_;
		gchar* _tmp159_;
		gchar* _tmp160_;
		ValaSymbol* _tmp161_;
		ValaSymbol* _tmp162_;
		gchar* _tmp163_;
		gchar* _tmp164_;
		gchar* _tmp165_;
		gchar* _tmp166_;
		_tmp157_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp158_ = _tmp157_;
		_tmp159_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp160_ = _tmp159_;
		_tmp161_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp162_ = _tmp161_;
		_tmp163_ = vala_symbol_get_full_name (_tmp162_);
		_tmp164_ = _tmp163_;
		_tmp165_ = g_strdup_printf ("%s hides inherited field `%s'. Use the `new' keyword if hiding was int" \
"entional", _tmp160_, _tmp164_);
		_tmp166_ = _tmp165_;
		vala_report_warning (_tmp158_, _tmp166_);
		_g_free0 (_tmp166_);
		_g_free0 (_tmp164_);
		_vala_code_node_unref0 (_tmp162_);
		_g_free0 (_tmp160_);
	}
	_tmp167_ = vala_code_context_get_analyzer (context);
	_tmp168_ = _tmp167_;
	_tmp169_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp168_, _tmp169_);
	_tmp170_ = vala_code_context_get_analyzer (context);
	_tmp171_ = _tmp170_;
	_tmp172_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp171_, _tmp172_);
	_tmp173_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp174_ = _tmp173_;
	result = !_tmp174_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


ValaMemberBinding
vala_field_get_binding (ValaField* self)
{
	ValaMemberBinding result;
	ValaMemberBinding _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_binding;
	result = _tmp0_;
	return result;
}


void
vala_field_set_binding (ValaField* self,
                        ValaMemberBinding value)
{
	g_return_if_fail (self != NULL);
	self->priv->_binding = value;
}


gboolean
vala_field_get_is_volatile (ValaField* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_volatile;
	result = _tmp0_;
	return result;
}


void
vala_field_set_is_volatile (ValaField* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_volatile = value;
}


static void
vala_field_class_init (ValaFieldClass * klass)
{
	vala_field_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_field_finalize;
	g_type_class_add_private (klass, sizeof (ValaFieldPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_field_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_field_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode *, ValaExpression*, ValaExpression*)) vala_field_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode *, ValaDataType*, ValaDataType*)) vala_field_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_field_real_check;
}


static void
vala_field_vala_lockable_interface_init (ValaLockableIface * iface)
{
	vala_field_vala_lockable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_lock_used = (gboolean (*) (ValaLockable *)) vala_field_real_get_lock_used;
	iface->set_lock_used = (void (*) (ValaLockable *, gboolean)) vala_field_real_set_lock_used;
}


static void
vala_field_instance_init (ValaField * self)
{
	self->priv = VALA_FIELD_GET_PRIVATE (self);
	self->priv->_binding = VALA_MEMBER_BINDING_INSTANCE;
	self->priv->lock_used = FALSE;
}


static void
vala_field_finalize (ValaCodeNode * obj)
{
	ValaField * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_FIELD, ValaField);
	VALA_CODE_NODE_CLASS (vala_field_parent_class)->finalize (obj);
}


/**
 * Represents a type or namespace field.
 */
GType
vala_field_get_type (void)
{
	static volatile gsize vala_field_type_id__volatile = 0;
	if (g_once_init_enter (&vala_field_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaFieldClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_field_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaField), 0, (GInstanceInitFunc) vala_field_instance_init, NULL };
		static const GInterfaceInfo vala_lockable_info = { (GInterfaceInitFunc) vala_field_vala_lockable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_field_type_id;
		vala_field_type_id = g_type_register_static (VALA_TYPE_VARIABLE, "ValaField", &g_define_type_info, 0);
		g_type_add_interface_static (vala_field_type_id, VALA_TYPE_LOCKABLE, &vala_lockable_info);
		g_once_init_leave (&vala_field_type_id__volatile, vala_field_type_id);
	}
	return vala_field_type_id__volatile;
}



