#ifndef _vdkb_maker_h
#define _vdkb_maker_h

#include <vdk/vdk.h>
#include <vdkb2/vdkb_types.h>
#include <stdlib.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <signal.h>
#include <errno.h>
#include <sys/wait.h>
#include <ctime>
#include "input.h"

#define IO_NONE 0
#define IO_STDOUT 1
#define IO_STDERR 2
#define MAX_BUFF 1024

class VDKBMaker: public VDKForm
{
  private:
  // gui
  VDKInput *inp1,*inp2;
  VDKTextView *text,*errtext;
  //
  VDKToolbar * toolbar;
  //
  guchar io;
  pid_t  pid;
  char **args;
  VDKBStringList* errlist;
  int status;
  bool hide_on_run; // wheter hide or not VDKBuilder on run
  int outlist; // load message list: 0 = stderr, 1 = stdout
  // response
  void quit(void);
  bool DoIO (VDKObject*);
  bool CanClose(void);
  
  public:
  static void reaper(int);
  VDKBMaker(VDKForm* app, char **args, VDKBStringList* list,
	    bool hide_on_run = false, int outlist = 0);
  ~VDKBMaker() { }
  static VDKBMaker *self;    
  void Setup(void); 
  inline int Pid() { return pid; }
  inline void Pid(int p) { pid = p; }
  void runcmd (void);
  bool HandleToolbar(VDKObject*);
  bool OnTextRealize(VDKObject* sender);
  void OnShow(VDKForm*);
  int ChildStatus() {return status;}
  void ChildStatus(int sts) {status = sts;}
  VDKBStringList* ErrorList() { return errlist; }
  DECLARE_SIGNAL_MAP(VDKBMaker);  
};
#endif




