// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SRHADD_4S_TRACE_AARCH64_H_
#define VIXL_SIM_SRHADD_4S_TRACE_AARCH64_H_

const uint32_t kExpected_NEON_srhadd_4S[] = {
  0x00007e00, 0x00007f00, 0x007ffd00, 0x00000000,
  0x00007e80, 0x00403e00, 0x003ffe80, 0x00000001,
  0x00403d80, 0x00003f80, 0x003ffe81, 0x00000001,
  0x00003f00, 0x00003f81, 0x003ffe81, 0x00000010,
  0x00003f01, 0x00003f81, 0x003ffe90, 0x0000003f,
  0x00003f01, 0x00003f90, 0x003ffebf, 0x0000003f,
  0x00003f10, 0x00003fbf, 0x003ffebf, 0x00000040,
  0x00003f3f, 0x00003fbf, 0x003ffec0, 0x00003fff,
  0x00003f3f, 0x00003fc0, 0x00403e7f, 0x00003fff,
  0x00003f40, 0x00007f7f, 0x00403e7f, 0x00004000,
  0x00007eff, 0x00007f7f, 0x00403e80, 0x1999999a,
  0x00007eff, 0x00007f80, 0x19d9981a, 0x2aaaaaab,
  0x00007f00, 0x1999d91a, 0x2aeaa92b, 0x3fffffff,
  0x1999d89a, 0x2aaaea2b, 0x403ffe7f, 0x3fffffff,
  0x2aaae9ab, 0x40003f7f, 0x403ffe7f, 0x40000000,
  0x40003eff, 0x40003f7f, 0x403ffe80, 0xc0000000,
  0x40003eff, 0x40003f80, 0xc03ffe80, 0xc0000001,
  0x40003f00, 0xc0003f80, 0xc03ffe81, 0xd5555555,
  0xc0003f00, 0xc0003f81, 0xd59553d5, 0xe6666666,
  0xc0003f01, 0xd55594d5, 0xe6a664e6, 0xffffc000,
  0xd5559455, 0xe666a5e6, 0x003fbe80, 0xffffc001,
  0xe666a566, 0xffffff80, 0x003fbe81, 0xffffc001,
  0xffffff00, 0xffffff81, 0x003fbe81, 0xffffc002,
  0xffffff01, 0xffffff81, 0x003fbe82, 0xffffffc0,
  0xffffff01, 0xffffff82, 0x003ffe40, 0xffffffc1,
  0xffffff02, 0x00003f40, 0x003ffe41, 0xffffffc1,
  0x00003ec0, 0x00003f41, 0x003ffe41, 0xffffffc2,
  0x00003ec1, 0x00003f41, 0x003ffe42, 0xfffffff0,
  0x00003ec1, 0x00003f42, 0x003ffe70, 0xffffffff,
  0x00003ec2, 0x00003f70, 0x003ffe7f, 0xffffffff,
  0x00003ef0, 0x00003f7f, 0x003ffe7f, 0x00000000,
  0x00003f7f, 0x003ffe7f, 0x00000000, 0x00000001,
  0x00003f7f, 0x003ffe80, 0x00000000, 0x00000001,
  0x00003f80, 0x003ffe80, 0x00000001, 0x00000002,
  0x00003f80, 0x003ffe81, 0x00000001, 0x00000011,
  0x00003f81, 0x003ffe81, 0x00000010, 0x0000003f,
  0x00003f81, 0x003ffe90, 0x0000003f, 0x00000040,
  0x00003f90, 0x003ffebf, 0x0000003f, 0x00000040,
  0x00003fbf, 0x003ffebf, 0x00000040, 0x00003fff,
  0x00003fbf, 0x003ffec0, 0x00003fff, 0x00004000,
  0x00003fc0, 0x00403e7f, 0x00003fff, 0x00004000,
  0x00007f7f, 0x00403e7f, 0x00004000, 0x1999999a,
  0x00007f7f, 0x00403e80, 0x1999999a, 0x2aaaaaab,
  0x00007f80, 0x19d9981a, 0x2aaaaaab, 0x3fffffff,
  0x1999d91a, 0x2aeaa92b, 0x3fffffff, 0x40000000,
  0x2aaaea2b, 0x403ffe7f, 0x3fffffff, 0x40000000,
  0x40003f7f, 0x403ffe7f, 0x40000000, 0xc0000001,
  0x40003f7f, 0x403ffe80, 0xc0000000, 0xc0000001,
  0x40003f80, 0xc03ffe80, 0xc0000001, 0xd5555556,
  0xc0003f80, 0xc03ffe81, 0xd5555555, 0xe6666667,
  0xc0003f81, 0xd59553d5, 0xe6666666, 0xffffc001,
  0xd55594d5, 0xe6a664e6, 0xffffc000, 0xffffc001,
  0xe666a5e6, 0x003fbe80, 0xffffc001, 0xffffc002,
  0xffffff80, 0x003fbe81, 0xffffc001, 0xffffc002,
  0xffffff81, 0x003fbe81, 0xffffc002, 0xffffffc1,
  0xffffff81, 0x003fbe82, 0xffffffc0, 0xffffffc1,
  0xffffff82, 0x003ffe40, 0xffffffc1, 0xffffffc2,
  0x00003f40, 0x003ffe41, 0xffffffc1, 0xffffffc2,
  0x00003f41, 0x003ffe41, 0xffffffc2, 0xfffffff1,
  0x00003f41, 0x003ffe42, 0xfffffff0, 0xffffffff,
  0x00003f42, 0x003ffe70, 0xffffffff, 0x00000000,
  0x00003f70, 0x003ffe7f, 0xffffffff, 0x00000000,
  0x003ffe7f, 0xffffffff, 0x00000000, 0x00000001,
  0x003ffe7f, 0x00000000, 0x00000001, 0x00000002,
  0x003ffe80, 0x00000000, 0x00000001, 0x00000002,
  0x003ffe80, 0x00000001, 0x00000002, 0x00000011,
  0x003ffe81, 0x00000001, 0x00000011, 0x00000040,
  0x003ffe81, 0x00000010, 0x0000003f, 0x00000040,
  0x003ffe90, 0x0000003f, 0x00000040, 0x00000041,
  0x003ffebf, 0x0000003f, 0x00000040, 0x00004000,
  0x003ffebf, 0x00000040, 0x00003fff, 0x00004000,
  0x003ffec0, 0x00003fff, 0x00004000, 0x00004001,
  0x00403e7f, 0x00003fff, 0x00004000, 0x1999999b,
  0x00403e7f, 0x00004000, 0x1999999a, 0x2aaaaaac,
  0x00403e80, 0x1999999a, 0x2aaaaaab, 0x40000000,
  0x19d9981a, 0x2aaaaaab, 0x3fffffff, 0x40000000,
  0x2aeaa92b, 0x3fffffff, 0x40000000, 0x40000001,
  0x403ffe7f, 0x3fffffff, 0x40000000, 0xc0000001,
  0x403ffe7f, 0x40000000, 0xc0000001, 0xc0000002,
  0x403ffe80, 0xc0000000, 0xc0000001, 0xd5555556,
  0xc03ffe80, 0xc0000001, 0xd5555556, 0xe6666667,
  0xc03ffe81, 0xd5555555, 0xe6666667, 0xffffc001,
  0xd59553d5, 0xe6666666, 0xffffc001, 0xffffc002,
  0xe6a664e6, 0xffffc000, 0xffffc001, 0xffffc002,
  0x003fbe80, 0xffffc001, 0xffffc002, 0xffffc003,
  0x003fbe81, 0xffffc001, 0xffffc002, 0xffffffc1,
  0x003fbe81, 0xffffc002, 0xffffffc1, 0xffffffc2,
  0x003fbe82, 0xffffffc0, 0xffffffc1, 0xffffffc2,
  0x003ffe40, 0xffffffc1, 0xffffffc2, 0xffffffc3,
  0x003ffe41, 0xffffffc1, 0xffffffc2, 0xfffffff1,
  0x003ffe41, 0xffffffc2, 0xfffffff1, 0x00000000,
  0x003ffe42, 0xfffffff0, 0xffffffff, 0x00000000,
  0x003ffe70, 0xffffffff, 0x00000000, 0x00000001,
  0xffffffff, 0x00000000, 0x00000001, 0x00000010,
  0xffffffff, 0x00000000, 0x00000001, 0x00000011,
  0x00000000, 0x00000001, 0x00000002, 0x00000011,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00000002, 0x00000011, 0x0000004f,
  0x00000001, 0x00000011, 0x00000040, 0x0000004f,
  0x00000010, 0x0000003f, 0x00000040, 0x00000050,
  0x0000003f, 0x00000040, 0x00000041, 0x0000400f,
  0x0000003f, 0x00000040, 0x00004000, 0x0000400f,
  0x00000040, 0x00003fff, 0x00004000, 0x00004010,
  0x00003fff, 0x00004000, 0x00004001, 0x199999aa,
  0x00003fff, 0x00004000, 0x1999999b, 0x2aaaaabb,
  0x00004000, 0x1999999a, 0x2aaaaaac, 0x4000000f,
  0x1999999a, 0x2aaaaaab, 0x40000000, 0x4000000f,
  0x2aaaaaab, 0x3fffffff, 0x40000000, 0x40000010,
  0x3fffffff, 0x40000000, 0x40000001, 0xc0000010,
  0x3fffffff, 0x40000000, 0xc0000001, 0xc0000011,
  0x40000000, 0xc0000001, 0xc0000002, 0xd5555565,
  0xc0000000, 0xc0000001, 0xd5555556, 0xe6666676,
  0xc0000001, 0xd5555556, 0xe6666667, 0xffffc010,
  0xd5555555, 0xe6666667, 0xffffc001, 0xffffc011,
  0xe6666666, 0xffffc001, 0xffffc002, 0xffffc011,
  0xffffc000, 0xffffc001, 0xffffc002, 0xffffc012,
  0xffffc001, 0xffffc002, 0xffffc003, 0xffffffd0,
  0xffffc001, 0xffffc002, 0xffffffc1, 0xffffffd1,
  0xffffc002, 0xffffffc1, 0xffffffc2, 0xffffffd1,
  0xffffffc0, 0xffffffc1, 0xffffffc2, 0xffffffd2,
  0xffffffc1, 0xffffffc2, 0xffffffc3, 0x00000000,
  0xffffffc1, 0xffffffc2, 0xfffffff1, 0x0000000f,
  0xffffffc2, 0xfffffff1, 0x00000000, 0x0000000f,
  0xfffffff0, 0xffffffff, 0x00000000, 0x00000010,
  0xffffffff, 0x00000000, 0x00000010, 0x0000003f,
  0x00000000, 0x00000001, 0x00000010, 0x0000003f,
  0x00000000, 0x00000001, 0x00000011, 0x00000040,
  0x00000001, 0x00000002, 0x00000011, 0x0000004f,
  0x00000001, 0x00000002, 0x00000020, 0x0000007d,
  0x00000002, 0x00000011, 0x0000004f, 0x0000007e,
  0x00000011, 0x00000040, 0x0000004f, 0x0000007e,
  0x0000003f, 0x00000040, 0x00000050, 0x0000403d,
  0x00000040, 0x00000041, 0x0000400f, 0x0000403e,
  0x00000040, 0x00004000, 0x0000400f, 0x0000403e,
  0x00003fff, 0x00004000, 0x00004010, 0x199999d8,
  0x00004000, 0x00004001, 0x199999aa, 0x2aaaaae9,
  0x00004000, 0x1999999b, 0x2aaaaabb, 0x4000003d,
  0x1999999a, 0x2aaaaaac, 0x4000000f, 0x4000003e,
  0x2aaaaaab, 0x40000000, 0x4000000f, 0x4000003e,
  0x3fffffff, 0x40000000, 0x40000010, 0xc000003f,
  0x40000000, 0x40000001, 0xc0000010, 0xc000003f,
  0x40000000, 0xc0000001, 0xc0000011, 0xd5555594,
  0xc0000001, 0xc0000002, 0xd5555565, 0xe66666a5,
  0xc0000001, 0xd5555556, 0xe6666676, 0xffffc03f,
  0xd5555556, 0xe6666667, 0xffffc010, 0xffffc03f,
  0xe6666667, 0xffffc001, 0xffffc011, 0xffffc040,
  0xffffc001, 0xffffc002, 0xffffc011, 0xffffc040,
  0xffffc001, 0xffffc002, 0xffffc012, 0xffffffff,
  0xffffc002, 0xffffc003, 0xffffffd0, 0xffffffff,
  0xffffc002, 0xffffffc1, 0xffffffd1, 0x00000000,
  0xffffffc1, 0xffffffc2, 0xffffffd1, 0x00000000,
  0xffffffc1, 0xffffffc2, 0xffffffd2, 0x0000002f,
  0xffffffc2, 0xffffffc3, 0x00000000, 0x0000003d,
  0xffffffc2, 0xfffffff1, 0x0000000f, 0x0000003e,
  0xfffffff1, 0x00000000, 0x0000000f, 0x0000003e,
  0x00000000, 0x0000000f, 0x0000003e, 0x0000003f,
  0x00000000, 0x00000010, 0x0000003f, 0x00000040,
  0x00000001, 0x00000010, 0x0000003f, 0x00000040,
  0x00000001, 0x00000011, 0x00000040, 0x0000004f,
  0x00000002, 0x00000011, 0x0000004f, 0x0000007e,
  0x00000002, 0x00000020, 0x0000007d, 0x0000007e,
  0x00000011, 0x0000004f, 0x0000007e, 0x0000007f,
  0x00000040, 0x0000004f, 0x0000007e, 0x0000403e,
  0x00000040, 0x00000050, 0x0000403d, 0x0000403e,
  0x00000041, 0x0000400f, 0x0000403e, 0x0000403f,
  0x00004000, 0x0000400f, 0x0000403e, 0x199999d9,
  0x00004000, 0x00004010, 0x199999d8, 0x2aaaaaea,
  0x00004001, 0x199999aa, 0x2aaaaae9, 0x4000003e,
  0x1999999b, 0x2aaaaabb, 0x4000003d, 0x4000003e,
  0x2aaaaaac, 0x4000000f, 0x4000003e, 0x4000003f,
  0x40000000, 0x4000000f, 0x4000003e, 0xc000003f,
  0x40000000, 0x40000010, 0xc000003f, 0xc0000040,
  0x40000001, 0xc0000010, 0xc000003f, 0xd5555594,
  0xc0000001, 0xc0000011, 0xd5555594, 0xe66666a5,
  0xc0000002, 0xd5555565, 0xe66666a5, 0xffffc03f,
  0xd5555556, 0xe6666676, 0xffffc03f, 0xffffc040,
  0xe6666667, 0xffffc010, 0xffffc03f, 0xffffc040,
  0xffffc001, 0xffffc011, 0xffffc040, 0xffffc041,
  0xffffc002, 0xffffc011, 0xffffc040, 0xffffffff,
  0xffffc002, 0xffffc012, 0xffffffff, 0x00000000,
  0xffffc003, 0xffffffd0, 0xffffffff, 0x00000000,
  0xffffffc1, 0xffffffd1, 0x00000000, 0x00000001,
  0xffffffc2, 0xffffffd1, 0x00000000, 0x0000002f,
  0xffffffc2, 0xffffffd2, 0x0000002f, 0x0000003e,
  0xffffffc3, 0x00000000, 0x0000003d, 0x0000003e,
  0xfffffff1, 0x0000000f, 0x0000003e, 0x0000003f,
  0x0000000f, 0x0000003e, 0x0000003f, 0x00000040,
  0x0000000f, 0x0000003e, 0x0000003f, 0x00000040,
  0x00000010, 0x0000003f, 0x00000040, 0x00000041,
  0x00000010, 0x0000003f, 0x00000040, 0x00000050,
  0x00000011, 0x00000040, 0x0000004f, 0x0000007e,
  0x00000011, 0x0000004f, 0x0000007e, 0x0000007f,
  0x00000020, 0x0000007d, 0x0000007e, 0x0000007f,
  0x0000004f, 0x0000007e, 0x0000007f, 0x0000403e,
  0x0000004f, 0x0000007e, 0x0000403e, 0x0000403f,
  0x00000050, 0x0000403d, 0x0000403e, 0x0000403f,
  0x0000400f, 0x0000403e, 0x0000403f, 0x199999d9,
  0x0000400f, 0x0000403e, 0x199999d9, 0x2aaaaaea,
  0x00004010, 0x199999d8, 0x2aaaaaea, 0x4000003e,
  0x199999aa, 0x2aaaaae9, 0x4000003e, 0x4000003f,
  0x2aaaaabb, 0x4000003d, 0x4000003e, 0x4000003f,
  0x4000000f, 0x4000003e, 0x4000003f, 0xc0000040,
  0x4000000f, 0x4000003e, 0xc000003f, 0xc0000040,
  0x40000010, 0xc000003f, 0xc0000040, 0xd5555595,
  0xc0000010, 0xc000003f, 0xd5555594, 0xe66666a6,
  0xc0000011, 0xd5555594, 0xe66666a5, 0xffffc040,
  0xd5555565, 0xe66666a5, 0xffffc03f, 0xffffc040,
  0xe6666676, 0xffffc03f, 0xffffc040, 0xffffc041,
  0xffffc010, 0xffffc03f, 0xffffc040, 0xffffc041,
  0xffffc011, 0xffffc040, 0xffffc041, 0x00000000,
  0xffffc011, 0xffffc040, 0xffffffff, 0x00000000,
  0xffffc012, 0xffffffff, 0x00000000, 0x00000001,
  0xffffffd0, 0xffffffff, 0x00000000, 0x00000001,
  0xffffffd1, 0x00000000, 0x00000001, 0x00000030,
  0xffffffd1, 0x00000000, 0x0000002f, 0x0000003e,
  0xffffffd2, 0x0000002f, 0x0000003e, 0x0000003f,
  0x00000000, 0x0000003d, 0x0000003e, 0x0000003f,
  0x0000003d, 0x0000003e, 0x0000003f, 0x00003fff,
  0x0000003e, 0x0000003f, 0x00000040, 0x00003fff,
  0x0000003e, 0x0000003f, 0x00000040, 0x00004000,
  0x0000003f, 0x00000040, 0x00000041, 0x0000400f,
  0x0000003f, 0x00000040, 0x00000050, 0x0000403d,
  0x00000040, 0x0000004f, 0x0000007e, 0x0000403e,
  0x0000004f, 0x0000007e, 0x0000007f, 0x0000403e,
  0x0000007d, 0x0000007e, 0x0000007f, 0x00007ffd,
  0x0000007e, 0x0000007f, 0x0000403e, 0x00007ffe,
  0x0000007e, 0x0000403e, 0x0000403f, 0x00007ffe,
  0x0000403d, 0x0000403e, 0x0000403f, 0x1999d998,
  0x0000403e, 0x0000403f, 0x199999d9, 0x2aaaeaa9,
  0x0000403e, 0x199999d9, 0x2aaaaaea, 0x40003ffd,
  0x199999d8, 0x2aaaaaea, 0x4000003e, 0x40003ffe,
  0x2aaaaae9, 0x4000003e, 0x4000003f, 0x40003ffe,
  0x4000003d, 0x4000003e, 0x4000003f, 0xc0003fff,
  0x4000003e, 0x4000003f, 0xc0000040, 0xc0003fff,
  0x4000003e, 0xc000003f, 0xc0000040, 0xd5559554,
  0xc000003f, 0xc0000040, 0xd5555595, 0xe666a665,
  0xc000003f, 0xd5555594, 0xe66666a6, 0xffffffff,
  0xd5555594, 0xe66666a5, 0xffffc040, 0xffffffff,
  0xe66666a5, 0xffffc03f, 0xffffc040, 0x00000000,
  0xffffc03f, 0xffffc040, 0xffffc041, 0x00000000,
  0xffffc03f, 0xffffc040, 0xffffc041, 0x00003fbf,
  0xffffc040, 0xffffc041, 0x00000000, 0x00003fbf,
  0xffffc040, 0xffffffff, 0x00000000, 0x00003fc0,
  0xffffffff, 0x00000000, 0x00000001, 0x00003fc0,
  0xffffffff, 0x00000000, 0x00000001, 0x00003fef,
  0x00000000, 0x00000001, 0x00000030, 0x00003ffd,
  0x00000000, 0x0000002f, 0x0000003e, 0x00003ffe,
  0x0000002f, 0x0000003e, 0x0000003f, 0x00003ffe,
  0x0000003e, 0x0000003f, 0x00003ffe, 0x00003fff,
  0x0000003e, 0x0000003f, 0x00003fff, 0x00004000,
  0x0000003f, 0x00000040, 0x00003fff, 0x00004000,
  0x0000003f, 0x00000040, 0x00004000, 0x0000400f,
  0x00000040, 0x00000041, 0x0000400f, 0x0000403e,
  0x00000040, 0x00000050, 0x0000403d, 0x0000403e,
  0x0000004f, 0x0000007e, 0x0000403e, 0x0000403f,
  0x0000007e, 0x0000007f, 0x0000403e, 0x00007ffe,
  0x0000007e, 0x0000007f, 0x00007ffd, 0x00007ffe,
  0x0000007f, 0x0000403e, 0x00007ffe, 0x00007fff,
  0x0000403e, 0x0000403f, 0x00007ffe, 0x1999d999,
  0x0000403e, 0x0000403f, 0x1999d998, 0x2aaaeaaa,
  0x0000403f, 0x199999d9, 0x2aaaeaa9, 0x40003ffe,
  0x199999d9, 0x2aaaaaea, 0x40003ffd, 0x40003ffe,
  0x2aaaaaea, 0x4000003e, 0x40003ffe, 0x40003fff,
  0x4000003e, 0x4000003f, 0x40003ffe, 0xc0003fff,
  0x4000003e, 0x4000003f, 0xc0003fff, 0xc0004000,
  0x4000003f, 0xc0000040, 0xc0003fff, 0xd5559554,
  0xc000003f, 0xc0000040, 0xd5559554, 0xe666a665,
  0xc0000040, 0xd5555595, 0xe666a665, 0xffffffff,
  0xd5555594, 0xe66666a6, 0xffffffff, 0x00000000,
  0xe66666a5, 0xffffc040, 0xffffffff, 0x00000000,
  0xffffc03f, 0xffffc040, 0x00000000, 0x00000001,
  0xffffc040, 0xffffc041, 0x00000000, 0x00003fbf,
  0xffffc040, 0xffffc041, 0x00003fbf, 0x00003fc0,
  0xffffc041, 0x00000000, 0x00003fbf, 0x00003fc0,
  0xffffffff, 0x00000000, 0x00003fc0, 0x00003fc1,
  0x00000000, 0x00000001, 0x00003fc0, 0x00003fef,
  0x00000000, 0x00000001, 0x00003fef, 0x00003ffe,
  0x00000001, 0x00000030, 0x00003ffd, 0x00003ffe,
  0x0000002f, 0x0000003e, 0x00003ffe, 0x00003fff,
  0x0000003e, 0x00003ffe, 0x00003fff, 0x00004000,
  0x0000003f, 0x00003ffe, 0x00003fff, 0x00004000,
  0x0000003f, 0x00003fff, 0x00004000, 0x00004001,
  0x00000040, 0x00003fff, 0x00004000, 0x00004010,
  0x00000040, 0x00004000, 0x0000400f, 0x0000403e,
  0x00000041, 0x0000400f, 0x0000403e, 0x0000403f,
  0x00000050, 0x0000403d, 0x0000403e, 0x0000403f,
  0x0000007e, 0x0000403e, 0x0000403f, 0x00007ffe,
  0x0000007f, 0x0000403e, 0x00007ffe, 0x00007fff,
  0x0000007f, 0x00007ffd, 0x00007ffe, 0x00007fff,
  0x0000403e, 0x00007ffe, 0x00007fff, 0x1999d999,
  0x0000403f, 0x00007ffe, 0x1999d999, 0x2aaaeaaa,
  0x0000403f, 0x1999d998, 0x2aaaeaaa, 0x40003ffe,
  0x199999d9, 0x2aaaeaa9, 0x40003ffe, 0x40003fff,
  0x2aaaaaea, 0x40003ffd, 0x40003ffe, 0x40003fff,
  0x4000003e, 0x40003ffe, 0x40003fff, 0xc0004000,
  0x4000003f, 0x40003ffe, 0xc0003fff, 0xc0004000,
  0x4000003f, 0xc0003fff, 0xc0004000, 0xd5559555,
  0xc0000040, 0xc0003fff, 0xd5559554, 0xe666a666,
  0xc0000040, 0xd5559554, 0xe666a665, 0x00000000,
  0xd5555595, 0xe666a665, 0xffffffff, 0x00000000,
  0xe66666a6, 0xffffffff, 0x00000000, 0x00000001,
  0xffffc040, 0xffffffff, 0x00000000, 0x00000001,
  0xffffc040, 0x00000000, 0x00000001, 0x00003fc0,
  0xffffc041, 0x00000000, 0x00003fbf, 0x00003fc0,
  0xffffc041, 0x00003fbf, 0x00003fc0, 0x00003fc1,
  0x00000000, 0x00003fbf, 0x00003fc0, 0x00003fc1,
  0x00000000, 0x00003fc0, 0x00003fc1, 0x00003ff0,
  0x00000001, 0x00003fc0, 0x00003fef, 0x00003ffe,
  0x00000001, 0x00003fef, 0x00003ffe, 0x00003fff,
  0x00000030, 0x00003ffd, 0x00003ffe, 0x00003fff,
  0x00003ffd, 0x00003ffe, 0x00003fff, 0x1999999a,
  0x00003ffe, 0x00003fff, 0x00004000, 0x1999999a,
  0x00003ffe, 0x00003fff, 0x00004000, 0x1999999b,
  0x00003fff, 0x00004000, 0x00004001, 0x199999aa,
  0x00003fff, 0x00004000, 0x00004010, 0x199999d8,
  0x00004000, 0x0000400f, 0x0000403e, 0x199999d9,
  0x0000400f, 0x0000403e, 0x0000403f, 0x199999d9,
  0x0000403d, 0x0000403e, 0x0000403f, 0x1999d998,
  0x0000403e, 0x0000403f, 0x00007ffe, 0x1999d999,
  0x0000403e, 0x00007ffe, 0x00007fff, 0x1999d999,
  0x00007ffd, 0x00007ffe, 0x00007fff, 0x33333333,
  0x00007ffe, 0x00007fff, 0x1999d999, 0x44444444,
  0x00007ffe, 0x1999d999, 0x2aaaeaaa, 0x59999998,
  0x1999d998, 0x2aaaeaaa, 0x40003ffe, 0x59999999,
  0x2aaaeaa9, 0x40003ffe, 0x40003fff, 0x59999999,
  0x40003ffd, 0x40003ffe, 0x40003fff, 0xd999999a,
  0x40003ffe, 0x40003fff, 0xc0004000, 0xd999999a,
  0x40003ffe, 0xc0003fff, 0xc0004000, 0xeeeeeeef,
  0xc0003fff, 0xc0004000, 0xd5559555, 0x00000000,
  0xc0003fff, 0xd5559554, 0xe666a666, 0x1999599a,
  0xd5559554, 0xe666a665, 0x00000000, 0x1999599a,
  0xe666a665, 0xffffffff, 0x00000000, 0x1999599b,
  0xffffffff, 0x00000000, 0x00000001, 0x1999599b,
  0xffffffff, 0x00000000, 0x00000001, 0x1999995a,
  0x00000000, 0x00000001, 0x00003fc0, 0x1999995a,
  0x00000000, 0x00003fbf, 0x00003fc0, 0x1999995b,
  0x00003fbf, 0x00003fc0, 0x00003fc1, 0x1999995b,
  0x00003fbf, 0x00003fc0, 0x00003fc1, 0x1999998a,
  0x00003fc0, 0x00003fc1, 0x00003ff0, 0x19999998,
  0x00003fc0, 0x00003fef, 0x00003ffe, 0x19999999,
  0x00003fef, 0x00003ffe, 0x00003fff, 0x19999999,
  0x00003ffe, 0x00003fff, 0x19999999, 0x2aaaaaab,
  0x00003ffe, 0x00003fff, 0x1999999a, 0x2aaaaaab,
  0x00003fff, 0x00004000, 0x1999999a, 0x2aaaaaac,
  0x00003fff, 0x00004000, 0x1999999b, 0x2aaaaabb,
  0x00004000, 0x00004001, 0x199999aa, 0x2aaaaae9,
  0x00004000, 0x00004010, 0x199999d8, 0x2aaaaaea,
  0x0000400f, 0x0000403e, 0x199999d9, 0x2aaaaaea,
  0x0000403e, 0x0000403f, 0x199999d9, 0x2aaaeaa9,
  0x0000403e, 0x0000403f, 0x1999d998, 0x2aaaeaaa,
  0x0000403f, 0x00007ffe, 0x1999d999, 0x2aaaeaaa,
  0x00007ffe, 0x00007fff, 0x1999d999, 0x44444444,
  0x00007ffe, 0x00007fff, 0x33333333, 0x55555555,
  0x00007fff, 0x1999d999, 0x44444444, 0x6aaaaaa9,
  0x1999d999, 0x2aaaeaaa, 0x59999998, 0x6aaaaaaa,
  0x2aaaeaaa, 0x40003ffe, 0x59999999, 0x6aaaaaaa,
  0x40003ffe, 0x40003fff, 0x59999999, 0xeaaaaaab,
  0x40003ffe, 0x40003fff, 0xd999999a, 0xeaaaaaab,
  0x40003fff, 0xc0004000, 0xd999999a, 0x00000000,
  0xc0003fff, 0xc0004000, 0xeeeeeeef, 0x11111111,
  0xc0004000, 0xd5559555, 0x00000000, 0x2aaa6aab,
  0xd5559554, 0xe666a666, 0x1999599a, 0x2aaa6aab,
  0xe666a665, 0x00000000, 0x1999599a, 0x2aaa6aac,
  0xffffffff, 0x00000000, 0x1999599b, 0x2aaa6aac,
  0x00000000, 0x00000001, 0x1999599b, 0x2aaaaa6b,
  0x00000000, 0x00000001, 0x1999995a, 0x2aaaaa6b,
  0x00000001, 0x00003fc0, 0x1999995a, 0x2aaaaa6c,
  0x00003fbf, 0x00003fc0, 0x1999995b, 0x2aaaaa6c,
  0x00003fc0, 0x00003fc1, 0x1999995b, 0x2aaaaa9b,
  0x00003fc0, 0x00003fc1, 0x1999998a, 0x2aaaaaa9,
  0x00003fc1, 0x00003ff0, 0x19999998, 0x2aaaaaaa,
  0x00003fef, 0x00003ffe, 0x19999999, 0x2aaaaaaa,
  0x00003ffe, 0x19999999, 0x2aaaaaaa, 0x3fffffff,
  0x00003fff, 0x19999999, 0x2aaaaaab, 0x3fffffff,
  0x00003fff, 0x1999999a, 0x2aaaaaab, 0x40000000,
  0x00004000, 0x1999999a, 0x2aaaaaac, 0x4000000f,
  0x00004000, 0x1999999b, 0x2aaaaabb, 0x4000003d,
  0x00004001, 0x199999aa, 0x2aaaaae9, 0x4000003e,
  0x00004010, 0x199999d8, 0x2aaaaaea, 0x4000003e,
  0x0000403e, 0x199999d9, 0x2aaaaaea, 0x40003ffd,
  0x0000403f, 0x199999d9, 0x2aaaeaa9, 0x40003ffe,
  0x0000403f, 0x1999d998, 0x2aaaeaaa, 0x40003ffe,
  0x00007ffe, 0x1999d999, 0x2aaaeaaa, 0x59999998,
  0x00007fff, 0x1999d999, 0x44444444, 0x6aaaaaa9,
  0x00007fff, 0x33333333, 0x55555555, 0x7ffffffd,
  0x1999d999, 0x44444444, 0x6aaaaaa9, 0x7ffffffe,
  0x2aaaeaaa, 0x59999998, 0x6aaaaaaa, 0x7ffffffe,
  0x40003ffe, 0x59999999, 0x6aaaaaaa, 0xffffffff,
  0x40003fff, 0x59999999, 0xeaaaaaab, 0xffffffff,
  0x40003fff, 0xd999999a, 0xeaaaaaab, 0x15555554,
  0xc0004000, 0xd999999a, 0x00000000, 0x26666665,
  0xc0004000, 0xeeeeeeef, 0x11111111, 0x3fffbfff,
  0xd5559555, 0x00000000, 0x2aaa6aab, 0x3fffbfff,
  0xe666a666, 0x1999599a, 0x2aaa6aab, 0x3fffc000,
  0x00000000, 0x1999599a, 0x2aaa6aac, 0x3fffc000,
  0x00000000, 0x1999599b, 0x2aaa6aac, 0x3fffffbf,
  0x00000001, 0x1999599b, 0x2aaaaa6b, 0x3fffffbf,
  0x00000001, 0x1999995a, 0x2aaaaa6b, 0x3fffffc0,
  0x00003fc0, 0x1999995a, 0x2aaaaa6c, 0x3fffffc0,
  0x00003fc0, 0x1999995b, 0x2aaaaa6c, 0x3fffffef,
  0x00003fc1, 0x1999995b, 0x2aaaaa9b, 0x3ffffffd,
  0x00003fc1, 0x1999998a, 0x2aaaaaa9, 0x3ffffffe,
  0x00003ff0, 0x19999998, 0x2aaaaaaa, 0x3ffffffe,
  0x19999998, 0x2aaaaaaa, 0x3ffffffe, 0x3fffffff,
  0x19999999, 0x2aaaaaaa, 0x3fffffff, 0x40000000,
  0x19999999, 0x2aaaaaab, 0x3fffffff, 0x40000000,
  0x1999999a, 0x2aaaaaab, 0x40000000, 0x4000000f,
  0x1999999a, 0x2aaaaaac, 0x4000000f, 0x4000003e,
  0x1999999b, 0x2aaaaabb, 0x4000003d, 0x4000003e,
  0x199999aa, 0x2aaaaae9, 0x4000003e, 0x4000003f,
  0x199999d8, 0x2aaaaaea, 0x4000003e, 0x40003ffe,
  0x199999d9, 0x2aaaaaea, 0x40003ffd, 0x40003ffe,
  0x199999d9, 0x2aaaeaa9, 0x40003ffe, 0x40003fff,
  0x1999d998, 0x2aaaeaaa, 0x40003ffe, 0x59999999,
  0x1999d999, 0x2aaaeaaa, 0x59999998, 0x6aaaaaaa,
  0x1999d999, 0x44444444, 0x6aaaaaa9, 0x7ffffffe,
  0x33333333, 0x55555555, 0x7ffffffd, 0x7ffffffe,
  0x44444444, 0x6aaaaaa9, 0x7ffffffe, 0x7fffffff,
  0x59999998, 0x6aaaaaaa, 0x7ffffffe, 0xffffffff,
  0x59999999, 0x6aaaaaaa, 0xffffffff, 0x00000000,
  0x59999999, 0xeaaaaaab, 0xffffffff, 0x15555554,
  0xd999999a, 0xeaaaaaab, 0x15555554, 0x26666665,
  0xd999999a, 0x00000000, 0x26666665, 0x3fffbfff,
  0xeeeeeeef, 0x11111111, 0x3fffbfff, 0x3fffc000,
  0x00000000, 0x2aaa6aab, 0x3fffbfff, 0x3fffc000,
  0x1999599a, 0x2aaa6aab, 0x3fffc000, 0x3fffc001,
  0x1999599a, 0x2aaa6aac, 0x3fffc000, 0x3fffffbf,
  0x1999599b, 0x2aaa6aac, 0x3fffffbf, 0x3fffffc0,
  0x1999599b, 0x2aaaaa6b, 0x3fffffbf, 0x3fffffc0,
  0x1999995a, 0x2aaaaa6b, 0x3fffffc0, 0x3fffffc1,
  0x1999995a, 0x2aaaaa6c, 0x3fffffc0, 0x3fffffef,
  0x1999995b, 0x2aaaaa6c, 0x3fffffef, 0x3ffffffe,
  0x1999995b, 0x2aaaaa9b, 0x3ffffffd, 0x3ffffffe,
  0x1999998a, 0x2aaaaaa9, 0x3ffffffe, 0x3fffffff,
  0x2aaaaaa9, 0x3ffffffe, 0x3fffffff, 0x40000000,
  0x2aaaaaaa, 0x3ffffffe, 0x3fffffff, 0x40000000,
  0x2aaaaaaa, 0x3fffffff, 0x40000000, 0x40000001,
  0x2aaaaaab, 0x3fffffff, 0x40000000, 0x40000010,
  0x2aaaaaab, 0x40000000, 0x4000000f, 0x4000003e,
  0x2aaaaaac, 0x4000000f, 0x4000003e, 0x4000003f,
  0x2aaaaabb, 0x4000003d, 0x4000003e, 0x4000003f,
  0x2aaaaae9, 0x4000003e, 0x4000003f, 0x40003ffe,
  0x2aaaaaea, 0x4000003e, 0x40003ffe, 0x40003fff,
  0x2aaaaaea, 0x40003ffd, 0x40003ffe, 0x40003fff,
  0x2aaaeaa9, 0x40003ffe, 0x40003fff, 0x59999999,
  0x2aaaeaaa, 0x40003ffe, 0x59999999, 0x6aaaaaaa,
  0x2aaaeaaa, 0x59999998, 0x6aaaaaaa, 0x7ffffffe,
  0x44444444, 0x6aaaaaa9, 0x7ffffffe, 0x7fffffff,
  0x55555555, 0x7ffffffd, 0x7ffffffe, 0x7fffffff,
  0x6aaaaaa9, 0x7ffffffe, 0x7fffffff, 0x00000000,
  0x6aaaaaaa, 0x7ffffffe, 0xffffffff, 0x00000000,
  0x6aaaaaaa, 0xffffffff, 0x00000000, 0x15555555,
  0xeaaaaaab, 0xffffffff, 0x15555554, 0x26666666,
  0xeaaaaaab, 0x15555554, 0x26666665, 0x3fffc000,
  0x00000000, 0x26666665, 0x3fffbfff, 0x3fffc000,
  0x11111111, 0x3fffbfff, 0x3fffc000, 0x3fffc001,
  0x2aaa6aab, 0x3fffbfff, 0x3fffc000, 0x3fffc001,
  0x2aaa6aab, 0x3fffc000, 0x3fffc001, 0x3fffffc0,
  0x2aaa6aac, 0x3fffc000, 0x3fffffbf, 0x3fffffc0,
  0x2aaa6aac, 0x3fffffbf, 0x3fffffc0, 0x3fffffc1,
  0x2aaaaa6b, 0x3fffffbf, 0x3fffffc0, 0x3fffffc1,
  0x2aaaaa6b, 0x3fffffc0, 0x3fffffc1, 0x3ffffff0,
  0x2aaaaa6c, 0x3fffffc0, 0x3fffffef, 0x3ffffffe,
  0x2aaaaa6c, 0x3fffffef, 0x3ffffffe, 0x3fffffff,
  0x2aaaaa9b, 0x3ffffffd, 0x3ffffffe, 0x3fffffff,
  0x3ffffffd, 0x3ffffffe, 0x3fffffff, 0xc0000000,
  0x3ffffffe, 0x3fffffff, 0x40000000, 0xc0000001,
  0x3ffffffe, 0x3fffffff, 0x40000000, 0xc0000001,
  0x3fffffff, 0x40000000, 0x40000001, 0xc0000010,
  0x3fffffff, 0x40000000, 0x40000010, 0xc000003f,
  0x40000000, 0x4000000f, 0x4000003e, 0xc000003f,
  0x4000000f, 0x4000003e, 0x4000003f, 0xc0000040,
  0x4000003d, 0x4000003e, 0x4000003f, 0xc0003fff,
  0x4000003e, 0x4000003f, 0x40003ffe, 0xc0003fff,
  0x4000003e, 0x40003ffe, 0x40003fff, 0xc0004000,
  0x40003ffd, 0x40003ffe, 0x40003fff, 0xd999999a,
  0x40003ffe, 0x40003fff, 0x59999999, 0xeaaaaaab,
  0x40003ffe, 0x59999999, 0x6aaaaaaa, 0xffffffff,
  0x59999998, 0x6aaaaaaa, 0x7ffffffe, 0xffffffff,
  0x6aaaaaa9, 0x7ffffffe, 0x7fffffff, 0x00000000,
  0x7ffffffd, 0x7ffffffe, 0x7fffffff, 0x80000000,
  0x7ffffffe, 0x7fffffff, 0x00000000, 0x80000001,
  0x7ffffffe, 0xffffffff, 0x00000000, 0x95555555,
  0xffffffff, 0x00000000, 0x15555555, 0xa6666666,
  0xffffffff, 0x15555554, 0x26666666, 0xbfffc000,
  0x15555554, 0x26666665, 0x3fffc000, 0xbfffc001,
  0x26666665, 0x3fffbfff, 0x3fffc000, 0xbfffc001,
  0x3fffbfff, 0x3fffc000, 0x3fffc001, 0xbfffc002,
  0x3fffbfff, 0x3fffc000, 0x3fffc001, 0xbfffffc0,
  0x3fffc000, 0x3fffc001, 0x3fffffc0, 0xbfffffc1,
  0x3fffc000, 0x3fffffbf, 0x3fffffc0, 0xbfffffc1,
  0x3fffffbf, 0x3fffffc0, 0x3fffffc1, 0xbfffffc2,
  0x3fffffbf, 0x3fffffc0, 0x3fffffc1, 0xbffffff0,
  0x3fffffc0, 0x3fffffc1, 0x3ffffff0, 0xbfffffff,
  0x3fffffc0, 0x3fffffef, 0x3ffffffe, 0xbfffffff,
  0x3fffffef, 0x3ffffffe, 0x3fffffff, 0xc0000000,
  0x3ffffffe, 0x3fffffff, 0xc0000000, 0xc0000001,
  0x3ffffffe, 0x3fffffff, 0xc0000000, 0xc0000001,
  0x3fffffff, 0x40000000, 0xc0000001, 0xc0000002,
  0x3fffffff, 0x40000000, 0xc0000001, 0xc0000011,
  0x40000000, 0x40000001, 0xc0000010, 0xc000003f,
  0x40000000, 0x40000010, 0xc000003f, 0xc0000040,
  0x4000000f, 0x4000003e, 0xc000003f, 0xc0000040,
  0x4000003e, 0x4000003f, 0xc0000040, 0xc0003fff,
  0x4000003e, 0x4000003f, 0xc0003fff, 0xc0004000,
  0x4000003f, 0x40003ffe, 0xc0003fff, 0xc0004000,
  0x40003ffe, 0x40003fff, 0xc0004000, 0xd999999a,
  0x40003ffe, 0x40003fff, 0xd999999a, 0xeaaaaaab,
  0x40003fff, 0x59999999, 0xeaaaaaab, 0xffffffff,
  0x59999999, 0x6aaaaaaa, 0xffffffff, 0x00000000,
  0x6aaaaaaa, 0x7ffffffe, 0xffffffff, 0x00000000,
  0x7ffffffe, 0x7fffffff, 0x00000000, 0x80000001,
  0x7ffffffe, 0x7fffffff, 0x80000000, 0x80000001,
  0x7fffffff, 0x00000000, 0x80000001, 0x95555556,
  0xffffffff, 0x00000000, 0x95555555, 0xa6666667,
  0x00000000, 0x15555555, 0xa6666666, 0xbfffc001,
  0x15555554, 0x26666666, 0xbfffc000, 0xbfffc001,
  0x26666665, 0x3fffc000, 0xbfffc001, 0xbfffc002,
  0x3fffbfff, 0x3fffc000, 0xbfffc001, 0xbfffc002,
  0x3fffc000, 0x3fffc001, 0xbfffc002, 0xbfffffc1,
  0x3fffc000, 0x3fffc001, 0xbfffffc0, 0xbfffffc1,
  0x3fffc001, 0x3fffffc0, 0xbfffffc1, 0xbfffffc2,
  0x3fffffbf, 0x3fffffc0, 0xbfffffc1, 0xbfffffc2,
  0x3fffffc0, 0x3fffffc1, 0xbfffffc2, 0xbffffff1,
  0x3fffffc0, 0x3fffffc1, 0xbffffff0, 0xbfffffff,
  0x3fffffc1, 0x3ffffff0, 0xbfffffff, 0xc0000000,
  0x3fffffef, 0x3ffffffe, 0xbfffffff, 0xc0000000,
  0x3ffffffe, 0xbfffffff, 0xc0000000, 0xd5555555,
  0x3fffffff, 0xc0000000, 0xc0000001, 0xd5555556,
  0x3fffffff, 0xc0000000, 0xc0000001, 0xd5555556,
  0x40000000, 0xc0000001, 0xc0000002, 0xd5555565,
  0x40000000, 0xc0000001, 0xc0000011, 0xd5555594,
  0x40000001, 0xc0000010, 0xc000003f, 0xd5555594,
  0x40000010, 0xc000003f, 0xc0000040, 0xd5555595,
  0x4000003e, 0xc000003f, 0xc0000040, 0xd5559554,
  0x4000003f, 0xc0000040, 0xc0003fff, 0xd5559554,
  0x4000003f, 0xc0003fff, 0xc0004000, 0xd5559555,
  0x40003ffe, 0xc0003fff, 0xc0004000, 0xeeeeeeef,
  0x40003fff, 0xc0004000, 0xd999999a, 0x00000000,
  0x40003fff, 0xd999999a, 0xeaaaaaab, 0x15555554,
  0x59999999, 0xeaaaaaab, 0xffffffff, 0x15555554,
  0x6aaaaaaa, 0xffffffff, 0x00000000, 0x15555555,
  0x7ffffffe, 0xffffffff, 0x00000000, 0x95555555,
  0x7fffffff, 0x00000000, 0x80000001, 0x95555556,
  0x7fffffff, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x00000000, 0x80000001, 0x95555556, 0xbbbbbbbb,
  0x00000000, 0x95555555, 0xa6666667, 0xd5551555,
  0x15555555, 0xa6666666, 0xbfffc001, 0xd5551556,
  0x26666666, 0xbfffc000, 0xbfffc001, 0xd5551556,
  0x3fffc000, 0xbfffc001, 0xbfffc002, 0xd5551557,
  0x3fffc000, 0xbfffc001, 0xbfffc002, 0xd5555515,
  0x3fffc001, 0xbfffc002, 0xbfffffc1, 0xd5555516,
  0x3fffc001, 0xbfffffc0, 0xbfffffc1, 0xd5555516,
  0x3fffffc0, 0xbfffffc1, 0xbfffffc2, 0xd5555517,
  0x3fffffc0, 0xbfffffc1, 0xbfffffc2, 0xd5555545,
  0x3fffffc1, 0xbfffffc2, 0xbffffff1, 0xd5555554,
  0x3fffffc1, 0xbffffff0, 0xbfffffff, 0xd5555554,
  0x3ffffff0, 0xbfffffff, 0xc0000000, 0xd5555555,
  0xbfffffff, 0xc0000000, 0xd5555555, 0xe6666666,
  0xbfffffff, 0xc0000000, 0xd5555555, 0xe6666667,
  0xc0000000, 0xc0000001, 0xd5555556, 0xe6666667,
  0xc0000000, 0xc0000001, 0xd5555556, 0xe6666676,
  0xc0000001, 0xc0000002, 0xd5555565, 0xe66666a5,
  0xc0000001, 0xc0000011, 0xd5555594, 0xe66666a5,
  0xc0000010, 0xc000003f, 0xd5555594, 0xe66666a6,
  0xc000003f, 0xc0000040, 0xd5555595, 0xe666a665,
  0xc000003f, 0xc0000040, 0xd5559554, 0xe666a665,
  0xc0000040, 0xc0003fff, 0xd5559554, 0xe666a666,
  0xc0003fff, 0xc0004000, 0xd5559555, 0x00000000,
  0xc0003fff, 0xc0004000, 0xeeeeeeef, 0x11111111,
  0xc0004000, 0xd999999a, 0x00000000, 0x26666665,
  0xd999999a, 0xeaaaaaab, 0x15555554, 0x26666665,
  0xeaaaaaab, 0xffffffff, 0x15555554, 0x26666666,
  0xffffffff, 0x00000000, 0x15555555, 0xa6666666,
  0xffffffff, 0x00000000, 0x95555555, 0xa6666667,
  0x00000000, 0x80000001, 0x95555556, 0xbbbbbbbb,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000001, 0x95555556, 0xbbbbbbbb, 0xe6662666,
  0x95555555, 0xa6666667, 0xd5551555, 0xe6662667,
  0xa6666666, 0xbfffc001, 0xd5551556, 0xe6662667,
  0xbfffc000, 0xbfffc001, 0xd5551556, 0xe6662668,
  0xbfffc001, 0xbfffc002, 0xd5551557, 0xe6666626,
  0xbfffc001, 0xbfffc002, 0xd5555515, 0xe6666627,
  0xbfffc002, 0xbfffffc1, 0xd5555516, 0xe6666627,
  0xbfffffc0, 0xbfffffc1, 0xd5555516, 0xe6666628,
  0xbfffffc1, 0xbfffffc2, 0xd5555517, 0xe6666656,
  0xbfffffc1, 0xbfffffc2, 0xd5555545, 0xe6666665,
  0xbfffffc2, 0xbffffff1, 0xd5555554, 0xe6666665,
  0xbffffff0, 0xbfffffff, 0xd5555554, 0xe6666666,
  0xbfffffff, 0xd5555554, 0xe6666666, 0xffffc000,
  0xc0000000, 0xd5555555, 0xe6666666, 0xffffc001,
  0xc0000000, 0xd5555555, 0xe6666667, 0xffffc001,
  0xc0000001, 0xd5555556, 0xe6666667, 0xffffc010,
  0xc0000001, 0xd5555556, 0xe6666676, 0xffffc03f,
  0xc0000002, 0xd5555565, 0xe66666a5, 0xffffc03f,
  0xc0000011, 0xd5555594, 0xe66666a5, 0xffffc040,
  0xc000003f, 0xd5555594, 0xe66666a6, 0xffffffff,
  0xc0000040, 0xd5555595, 0xe666a665, 0xffffffff,
  0xc0000040, 0xd5559554, 0xe666a665, 0x00000000,
  0xc0003fff, 0xd5559554, 0xe666a666, 0x1999599a,
  0xc0004000, 0xd5559555, 0x00000000, 0x2aaa6aab,
  0xc0004000, 0xeeeeeeef, 0x11111111, 0x3fffbfff,
  0xd999999a, 0x00000000, 0x26666665, 0x3fffbfff,
  0xeaaaaaab, 0x15555554, 0x26666665, 0x3fffc000,
  0xffffffff, 0x15555554, 0x26666666, 0xbfffc000,
  0x00000000, 0x15555555, 0xa6666666, 0xbfffc001,
  0x00000000, 0x95555555, 0xa6666667, 0xd5551555,
  0x80000001, 0x95555556, 0xbbbbbbbb, 0xe6662666,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0x95555556, 0xbbbbbbbb, 0xe6662666, 0xffff8001,
  0xa6666667, 0xd5551555, 0xe6662667, 0xffff8001,
  0xbfffc001, 0xd5551556, 0xe6662667, 0xffff8002,
  0xbfffc001, 0xd5551556, 0xe6662668, 0xffffbfc0,
  0xbfffc002, 0xd5551557, 0xe6666626, 0xffffbfc1,
  0xbfffc002, 0xd5555515, 0xe6666627, 0xffffbfc1,
  0xbfffffc1, 0xd5555516, 0xe6666627, 0xffffbfc2,
  0xbfffffc1, 0xd5555516, 0xe6666628, 0xffffbff0,
  0xbfffffc2, 0xd5555517, 0xe6666656, 0xffffbfff,
  0xbfffffc2, 0xd5555545, 0xe6666665, 0xffffbfff,
  0xbffffff1, 0xd5555554, 0xe6666665, 0xffffc000,
  0xd5555554, 0xe6666665, 0xffffc000, 0xffffc001,
  0xd5555554, 0xe6666666, 0xffffc000, 0xffffc001,
  0xd5555555, 0xe6666666, 0xffffc001, 0xffffc002,
  0xd5555555, 0xe6666667, 0xffffc001, 0xffffc011,
  0xd5555556, 0xe6666667, 0xffffc010, 0xffffc03f,
  0xd5555556, 0xe6666676, 0xffffc03f, 0xffffc040,
  0xd5555565, 0xe66666a5, 0xffffc03f, 0xffffc040,
  0xd5555594, 0xe66666a5, 0xffffc040, 0xffffffff,
  0xd5555594, 0xe66666a6, 0xffffffff, 0x00000000,
  0xd5555595, 0xe666a665, 0xffffffff, 0x00000000,
  0xd5559554, 0xe666a665, 0x00000000, 0x1999599a,
  0xd5559554, 0xe666a666, 0x1999599a, 0x2aaa6aab,
  0xd5559555, 0x00000000, 0x2aaa6aab, 0x3fffbfff,
  0xeeeeeeef, 0x11111111, 0x3fffbfff, 0x3fffc000,
  0x00000000, 0x26666665, 0x3fffbfff, 0x3fffc000,
  0x15555554, 0x26666665, 0x3fffc000, 0xbfffc001,
  0x15555554, 0x26666666, 0xbfffc000, 0xbfffc001,
  0x15555555, 0xa6666666, 0xbfffc001, 0xd5551556,
  0x95555555, 0xa6666667, 0xd5551555, 0xe6662667,
  0x95555556, 0xbbbbbbbb, 0xe6662666, 0xffff8001,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xbbbbbbbb, 0xe6662666, 0xffff8001, 0xffff8002,
  0xd5551555, 0xe6662667, 0xffff8001, 0xffff8002,
  0xd5551556, 0xe6662667, 0xffff8002, 0xffffbfc1,
  0xd5551556, 0xe6662668, 0xffffbfc0, 0xffffbfc1,
  0xd5551557, 0xe6666626, 0xffffbfc1, 0xffffbfc2,
  0xd5555515, 0xe6666627, 0xffffbfc1, 0xffffbfc2,
  0xd5555516, 0xe6666627, 0xffffbfc2, 0xffffbff1,
  0xd5555516, 0xe6666628, 0xffffbff0, 0xffffbfff,
  0xd5555517, 0xe6666656, 0xffffbfff, 0xffffc000,
  0xd5555545, 0xe6666665, 0xffffbfff, 0xffffc000,
  0xe6666665, 0xffffbfff, 0xffffc000, 0xffffc001,
  0xe6666665, 0xffffc000, 0xffffc001, 0xffffc002,
  0xe6666666, 0xffffc000, 0xffffc001, 0xffffc002,
  0xe6666666, 0xffffc001, 0xffffc002, 0xffffc011,
  0xe6666667, 0xffffc001, 0xffffc011, 0xffffc040,
  0xe6666667, 0xffffc010, 0xffffc03f, 0xffffc040,
  0xe6666676, 0xffffc03f, 0xffffc040, 0xffffc041,
  0xe66666a5, 0xffffc03f, 0xffffc040, 0x00000000,
  0xe66666a5, 0xffffc040, 0xffffffff, 0x00000000,
  0xe66666a6, 0xffffffff, 0x00000000, 0x00000001,
  0xe666a665, 0xffffffff, 0x00000000, 0x1999599b,
  0xe666a665, 0x00000000, 0x1999599a, 0x2aaa6aac,
  0xe666a666, 0x1999599a, 0x2aaa6aab, 0x3fffc000,
  0x00000000, 0x2aaa6aab, 0x3fffbfff, 0x3fffc000,
  0x11111111, 0x3fffbfff, 0x3fffc000, 0x3fffc001,
  0x26666665, 0x3fffbfff, 0x3fffc000, 0xbfffc001,
  0x26666665, 0x3fffc000, 0xbfffc001, 0xbfffc002,
  0x26666666, 0xbfffc000, 0xbfffc001, 0xd5551556,
  0xa6666666, 0xbfffc001, 0xd5551556, 0xe6662667,
  0xa6666667, 0xd5551555, 0xe6662667, 0xffff8001,
  0xbbbbbbbb, 0xe6662666, 0xffff8001, 0xffff8002,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xe6662666, 0xffff8001, 0xffff8002, 0xffff8003,
  0xe6662667, 0xffff8001, 0xffff8002, 0xffffbfc1,
  0xe6662667, 0xffff8002, 0xffffbfc1, 0xffffbfc2,
  0xe6662668, 0xffffbfc0, 0xffffbfc1, 0xffffbfc2,
  0xe6666626, 0xffffbfc1, 0xffffbfc2, 0xffffbfc3,
  0xe6666627, 0xffffbfc1, 0xffffbfc2, 0xffffbff1,
  0xe6666627, 0xffffbfc2, 0xffffbff1, 0xffffc000,
  0xe6666628, 0xffffbff0, 0xffffbfff, 0xffffc000,
  0xe6666656, 0xffffbfff, 0xffffc000, 0xffffc001,
  0xffffbfff, 0xffffc000, 0xffffc001, 0xffffc002,
  0xffffbfff, 0xffffc000, 0xffffc001, 0xffffc002,
  0xffffc000, 0xffffc001, 0xffffc002, 0xffffc003,
  0xffffc000, 0xffffc001, 0xffffc002, 0xffffc012,
  0xffffc001, 0xffffc002, 0xffffc011, 0xffffc040,
  0xffffc001, 0xffffc011, 0xffffc040, 0xffffc041,
  0xffffc010, 0xffffc03f, 0xffffc040, 0xffffc041,
  0xffffc03f, 0xffffc040, 0xffffc041, 0x00000000,
  0xffffc03f, 0xffffc040, 0x00000000, 0x00000001,
  0xffffc040, 0xffffffff, 0x00000000, 0x00000001,
  0xffffffff, 0x00000000, 0x00000001, 0x1999599b,
  0xffffffff, 0x00000000, 0x1999599b, 0x2aaa6aac,
  0x00000000, 0x1999599a, 0x2aaa6aac, 0x3fffc000,
  0x1999599a, 0x2aaa6aab, 0x3fffc000, 0x3fffc001,
  0x2aaa6aab, 0x3fffbfff, 0x3fffc000, 0x3fffc001,
  0x3fffbfff, 0x3fffc000, 0x3fffc001, 0xbfffc002,
  0x3fffbfff, 0x3fffc000, 0xbfffc001, 0xbfffc002,
  0x3fffc000, 0xbfffc001, 0xbfffc002, 0xd5551557,
  0xbfffc000, 0xbfffc001, 0xd5551556, 0xe6662668,
  0xbfffc001, 0xd5551556, 0xe6662667, 0xffff8002,
  0xd5551555, 0xe6662667, 0xffff8001, 0xffff8002,
  0xe6662666, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffbfc2,
  0xffff8001, 0xffff8002, 0xffffbfc1, 0xffffbfc2,
  0xffff8002, 0xffffbfc1, 0xffffbfc2, 0xffffbfc3,
  0xffffbfc0, 0xffffbfc1, 0xffffbfc2, 0xffffbfc3,
  0xffffbfc1, 0xffffbfc2, 0xffffbfc3, 0xffffbff2,
  0xffffbfc1, 0xffffbfc2, 0xffffbff1, 0xffffc000,
  0xffffbfc2, 0xffffbff1, 0xffffc000, 0xffffc001,
  0xffffbff0, 0xffffbfff, 0xffffc000, 0xffffc001,
  0xffffbfff, 0xffffc000, 0xffffc001, 0xffffffc0,
  0xffffc000, 0xffffc001, 0xffffc002, 0xffffffc1,
  0xffffc000, 0xffffc001, 0xffffc002, 0xffffffc1,
  0xffffc001, 0xffffc002, 0xffffc003, 0xffffffd0,
  0xffffc001, 0xffffc002, 0xffffc012, 0xffffffff,
  0xffffc002, 0xffffc011, 0xffffc040, 0xffffffff,
  0xffffc011, 0xffffc040, 0xffffc041, 0x00000000,
  0xffffc03f, 0xffffc040, 0xffffc041, 0x00003fbf,
  0xffffc040, 0xffffc041, 0x00000000, 0x00003fbf,
  0xffffc040, 0x00000000, 0x00000001, 0x00003fc0,
  0xffffffff, 0x00000000, 0x00000001, 0x1999995a,
  0x00000000, 0x00000001, 0x1999599b, 0x2aaaaa6b,
  0x00000000, 0x1999599b, 0x2aaa6aac, 0x3fffffbf,
  0x1999599a, 0x2aaa6aac, 0x3fffc000, 0x3fffffbf,
  0x2aaa6aab, 0x3fffc000, 0x3fffc001, 0x3fffffc0,
  0x3fffbfff, 0x3fffc000, 0x3fffc001, 0xbfffffc0,
  0x3fffc000, 0x3fffc001, 0xbfffc002, 0xbfffffc1,
  0x3fffc000, 0xbfffc001, 0xbfffc002, 0xd5555515,
  0xbfffc001, 0xbfffc002, 0xd5551557, 0xe6666626,
  0xbfffc001, 0xd5551556, 0xe6662668, 0xffffbfc0,
  0xd5551556, 0xe6662667, 0xffff8002, 0xffffbfc1,
  0xe6662667, 0xffff8001, 0xffff8002, 0xffffbfc1,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffbfc2,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8002, 0xffff8003, 0xffffbfc2, 0xffffff81,
  0xffff8002, 0xffffbfc1, 0xffffbfc2, 0xffffff81,
  0xffffbfc1, 0xffffbfc2, 0xffffbfc3, 0xffffff82,
  0xffffbfc1, 0xffffbfc2, 0xffffbfc3, 0xffffffb0,
  0xffffbfc2, 0xffffbfc3, 0xffffbff2, 0xffffffbf,
  0xffffbfc2, 0xffffbff1, 0xffffc000, 0xffffffbf,
  0xffffbff1, 0xffffc000, 0xffffc001, 0xffffffc0,
  0xffffc000, 0xffffc001, 0xffffffc0, 0xffffffc1,
  0xffffc000, 0xffffc001, 0xffffffc0, 0xffffffc1,
  0xffffc001, 0xffffc002, 0xffffffc1, 0xffffffc2,
  0xffffc001, 0xffffc002, 0xffffffc1, 0xffffffd1,
  0xffffc002, 0xffffc003, 0xffffffd0, 0xffffffff,
  0xffffc002, 0xffffc012, 0xffffffff, 0x00000000,
  0xffffc011, 0xffffc040, 0xffffffff, 0x00000000,
  0xffffc040, 0xffffc041, 0x00000000, 0x00003fbf,
  0xffffc040, 0xffffc041, 0x00003fbf, 0x00003fc0,
  0xffffc041, 0x00000000, 0x00003fbf, 0x00003fc0,
  0x00000000, 0x00000001, 0x00003fc0, 0x1999995a,
  0x00000000, 0x00000001, 0x1999995a, 0x2aaaaa6b,
  0x00000001, 0x1999599b, 0x2aaaaa6b, 0x3fffffbf,
  0x1999599b, 0x2aaa6aac, 0x3fffffbf, 0x3fffffc0,
  0x2aaa6aac, 0x3fffc000, 0x3fffffbf, 0x3fffffc0,
  0x3fffc000, 0x3fffc001, 0x3fffffc0, 0xbfffffc1,
  0x3fffc000, 0x3fffc001, 0xbfffffc0, 0xbfffffc1,
  0x3fffc001, 0xbfffc002, 0xbfffffc1, 0xd5555516,
  0xbfffc001, 0xbfffc002, 0xd5555515, 0xe6666627,
  0xbfffc002, 0xd5551557, 0xe6666626, 0xffffbfc1,
  0xd5551556, 0xe6662668, 0xffffbfc0, 0xffffbfc1,
  0xe6662667, 0xffff8002, 0xffffbfc1, 0xffffbfc2,
  0xffff8001, 0xffff8002, 0xffffbfc1, 0xffffbfc2,
  0xffff8002, 0xffff8003, 0xffffbfc2, 0xffffff81,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8003, 0xffffbfc2, 0xffffff81, 0xffffff82,
  0xffffbfc1, 0xffffbfc2, 0xffffff81, 0xffffff82,
  0xffffbfc2, 0xffffbfc3, 0xffffff82, 0xffffffb1,
  0xffffbfc2, 0xffffbfc3, 0xffffffb0, 0xffffffbf,
  0xffffbfc3, 0xffffbff2, 0xffffffbf, 0xffffffc0,
  0xffffbff1, 0xffffc000, 0xffffffbf, 0xffffffc0,
  0xffffc000, 0xffffffbf, 0xffffffc0, 0xffffffc1,
  0xffffc001, 0xffffffc0, 0xffffffc1, 0xffffffc2,
  0xffffc001, 0xffffffc0, 0xffffffc1, 0xffffffc2,
  0xffffc002, 0xffffffc1, 0xffffffc2, 0xffffffd1,
  0xffffc002, 0xffffffc1, 0xffffffd1, 0x00000000,
  0xffffc003, 0xffffffd0, 0xffffffff, 0x00000000,
  0xffffc012, 0xffffffff, 0x00000000, 0x00000001,
  0xffffc040, 0xffffffff, 0x00000000, 0x00003fc0,
  0xffffc041, 0x00000000, 0x00003fbf, 0x00003fc0,
  0xffffc041, 0x00003fbf, 0x00003fc0, 0x00003fc1,
  0x00000000, 0x00003fbf, 0x00003fc0, 0x1999995b,
  0x00000001, 0x00003fc0, 0x1999995a, 0x2aaaaa6c,
  0x00000001, 0x1999995a, 0x2aaaaa6b, 0x3fffffc0,
  0x1999599b, 0x2aaaaa6b, 0x3fffffbf, 0x3fffffc0,
  0x2aaa6aac, 0x3fffffbf, 0x3fffffc0, 0x3fffffc1,
  0x3fffc000, 0x3fffffbf, 0x3fffffc0, 0xbfffffc1,
  0x3fffc001, 0x3fffffc0, 0xbfffffc1, 0xbfffffc2,
  0x3fffc001, 0xbfffffc0, 0xbfffffc1, 0xd5555516,
  0xbfffc002, 0xbfffffc1, 0xd5555516, 0xe6666627,
  0xbfffc002, 0xd5555515, 0xe6666627, 0xffffbfc1,
  0xd5551557, 0xe6666626, 0xffffbfc1, 0xffffbfc2,
  0xe6662668, 0xffffbfc0, 0xffffbfc1, 0xffffbfc2,
  0xffff8002, 0xffffbfc1, 0xffffbfc2, 0xffffbfc3,
  0xffff8002, 0xffffbfc1, 0xffffbfc2, 0xffffff81,
  0xffff8003, 0xffffbfc2, 0xffffff81, 0xffffff82,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffffbfc2, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffbfc2, 0xffffff81, 0xffffff82, 0xffffffb1,
  0xffffbfc3, 0xffffff82, 0xffffffb1, 0xffffffc0,
  0xffffbfc3, 0xffffffb0, 0xffffffbf, 0xffffffc0,
  0xffffbff2, 0xffffffbf, 0xffffffc0, 0xffffffc1,
  0xffffffbf, 0xffffffc0, 0xffffffc1, 0xffffffc2,
  0xffffffbf, 0xffffffc0, 0xffffffc1, 0xffffffc2,
  0xffffffc0, 0xffffffc1, 0xffffffc2, 0xffffffc3,
  0xffffffc0, 0xffffffc1, 0xffffffc2, 0xffffffd2,
  0xffffffc1, 0xffffffc2, 0xffffffd1, 0x00000000,
  0xffffffc1, 0xffffffd1, 0x00000000, 0x00000001,
  0xffffffd0, 0xffffffff, 0x00000000, 0x00000001,
  0xffffffff, 0x00000000, 0x00000001, 0x00003fc0,
  0xffffffff, 0x00000000, 0x00003fc0, 0x00003fc1,
  0x00000000, 0x00003fbf, 0x00003fc0, 0x00003fc1,
  0x00003fbf, 0x00003fc0, 0x00003fc1, 0x1999995b,
  0x00003fbf, 0x00003fc0, 0x1999995b, 0x2aaaaa6c,
  0x00003fc0, 0x1999995a, 0x2aaaaa6c, 0x3fffffc0,
  0x1999995a, 0x2aaaaa6b, 0x3fffffc0, 0x3fffffc1,
  0x2aaaaa6b, 0x3fffffbf, 0x3fffffc0, 0x3fffffc1,
  0x3fffffbf, 0x3fffffc0, 0x3fffffc1, 0xbfffffc2,
  0x3fffffbf, 0x3fffffc0, 0xbfffffc1, 0xbfffffc2,
  0x3fffffc0, 0xbfffffc1, 0xbfffffc2, 0xd5555517,
  0xbfffffc0, 0xbfffffc1, 0xd5555516, 0xe6666628,
  0xbfffffc1, 0xd5555516, 0xe6666627, 0xffffbfc2,
  0xd5555515, 0xe6666627, 0xffffbfc1, 0xffffbfc2,
  0xe6666626, 0xffffbfc1, 0xffffbfc2, 0xffffbfc3,
  0xffffbfc0, 0xffffbfc1, 0xffffbfc2, 0xffffbfc3,
  0xffffbfc1, 0xffffbfc2, 0xffffbfc3, 0xffffff82,
  0xffffbfc1, 0xffffbfc2, 0xffffff81, 0xffffff82,
  0xffffbfc2, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff81, 0xffffff82, 0xffffff83, 0xffffffb2,
  0xffffff81, 0xffffff82, 0xffffffb1, 0xffffffc0,
  0xffffff82, 0xffffffb1, 0xffffffc0, 0xffffffc1,
  0xffffffb0, 0xffffffbf, 0xffffffc0, 0xffffffc1,
  0xffffffbf, 0xffffffc0, 0xffffffc1, 0xfffffff0,
  0xffffffc0, 0xffffffc1, 0xffffffc2, 0xfffffff1,
  0xffffffc0, 0xffffffc1, 0xffffffc2, 0xfffffff1,
  0xffffffc1, 0xffffffc2, 0xffffffc3, 0x00000000,
  0xffffffc1, 0xffffffc2, 0xffffffd2, 0x0000002f,
  0xffffffc2, 0xffffffd1, 0x00000000, 0x0000002f,
  0xffffffd1, 0x00000000, 0x00000001, 0x00000030,
  0xffffffff, 0x00000000, 0x00000001, 0x00003fef,
  0x00000000, 0x00000001, 0x00003fc0, 0x00003fef,
  0x00000000, 0x00003fc0, 0x00003fc1, 0x00003ff0,
  0x00003fbf, 0x00003fc0, 0x00003fc1, 0x1999998a,
  0x00003fc0, 0x00003fc1, 0x1999995b, 0x2aaaaa9b,
  0x00003fc0, 0x1999995b, 0x2aaaaa6c, 0x3fffffef,
  0x1999995a, 0x2aaaaa6c, 0x3fffffc0, 0x3fffffef,
  0x2aaaaa6b, 0x3fffffc0, 0x3fffffc1, 0x3ffffff0,
  0x3fffffbf, 0x3fffffc0, 0x3fffffc1, 0xbffffff0,
  0x3fffffc0, 0x3fffffc1, 0xbfffffc2, 0xbffffff1,
  0x3fffffc0, 0xbfffffc1, 0xbfffffc2, 0xd5555545,
  0xbfffffc1, 0xbfffffc2, 0xd5555517, 0xe6666656,
  0xbfffffc1, 0xd5555516, 0xe6666628, 0xffffbff0,
  0xd5555516, 0xe6666627, 0xffffbfc2, 0xffffbff1,
  0xe6666627, 0xffffbfc1, 0xffffbfc2, 0xffffbff1,
  0xffffbfc1, 0xffffbfc2, 0xffffbfc3, 0xffffbff2,
  0xffffbfc1, 0xffffbfc2, 0xffffbfc3, 0xffffffb0,
  0xffffbfc2, 0xffffbfc3, 0xffffff82, 0xffffffb1,
  0xffffbfc2, 0xffffff81, 0xffffff82, 0xffffffb1,
  0xffffff81, 0xffffff82, 0xffffff83, 0xffffffb2,
  0xffffff81, 0xffffff82, 0xffffff83, 0xffffffe0,
  0xffffff82, 0xffffff83, 0xffffffb2, 0xffffffef,
  0xffffff82, 0xffffffb1, 0xffffffc0, 0xffffffef,
  0xffffffb1, 0xffffffc0, 0xffffffc1, 0xfffffff0,
  0xffffffc0, 0xffffffc1, 0xfffffff0, 0xffffffff,
  0xffffffc0, 0xffffffc1, 0xfffffff0, 0xffffffff,
  0xffffffc1, 0xffffffc2, 0xfffffff1, 0x00000000,
  0xffffffc1, 0xffffffc2, 0xfffffff1, 0x0000000f,
  0xffffffc2, 0xffffffc3, 0x00000000, 0x0000003d,
  0xffffffc2, 0xffffffd2, 0x0000002f, 0x0000003e,
  0xffffffd1, 0x00000000, 0x0000002f, 0x0000003e,
  0x00000000, 0x00000001, 0x00000030, 0x00003ffd,
  0x00000000, 0x00000001, 0x00003fef, 0x00003ffe,
  0x00000001, 0x00003fc0, 0x00003fef, 0x00003ffe,
  0x00003fc0, 0x00003fc1, 0x00003ff0, 0x19999998,
  0x00003fc0, 0x00003fc1, 0x1999998a, 0x2aaaaaa9,
  0x00003fc1, 0x1999995b, 0x2aaaaa9b, 0x3ffffffd,
  0x1999995b, 0x2aaaaa6c, 0x3fffffef, 0x3ffffffe,
  0x2aaaaa6c, 0x3fffffc0, 0x3fffffef, 0x3ffffffe,
  0x3fffffc0, 0x3fffffc1, 0x3ffffff0, 0xbfffffff,
  0x3fffffc0, 0x3fffffc1, 0xbffffff0, 0xbfffffff,
  0x3fffffc1, 0xbfffffc2, 0xbffffff1, 0xd5555554,
  0xbfffffc1, 0xbfffffc2, 0xd5555545, 0xe6666665,
  0xbfffffc2, 0xd5555517, 0xe6666656, 0xffffbfff,
  0xd5555516, 0xe6666628, 0xffffbff0, 0xffffbfff,
  0xe6666627, 0xffffbfc2, 0xffffbff1, 0xffffc000,
  0xffffbfc1, 0xffffbfc2, 0xffffbff1, 0xffffc000,
  0xffffbfc2, 0xffffbfc3, 0xffffbff2, 0xffffffbf,
  0xffffbfc2, 0xffffbfc3, 0xffffffb0, 0xffffffbf,
  0xffffbfc3, 0xffffff82, 0xffffffb1, 0xffffffc0,
  0xffffff81, 0xffffff82, 0xffffffb1, 0xffffffc0,
  0xffffff82, 0xffffff83, 0xffffffb2, 0xffffffef,
  0xffffff82, 0xffffff83, 0xffffffe0, 0xfffffffd,
  0xffffff83, 0xffffffb2, 0xffffffef, 0xfffffffe,
  0xffffffb1, 0xffffffc0, 0xffffffef, 0xfffffffe,
  0xffffffc0, 0xffffffef, 0xfffffffe, 0xffffffff,
  0xffffffc1, 0xfffffff0, 0xffffffff, 0x00000000,
  0xffffffc1, 0xfffffff0, 0xffffffff, 0x00000000,
  0xffffffc2, 0xfffffff1, 0x00000000, 0x0000000f,
  0xffffffc2, 0xfffffff1, 0x0000000f, 0x0000003e,
  0xffffffc3, 0x00000000, 0x0000003d, 0x0000003e,
  0xffffffd2, 0x0000002f, 0x0000003e, 0x0000003f,
  0x00000000, 0x0000002f, 0x0000003e, 0x00003ffe,
  0x00000001, 0x00000030, 0x00003ffd, 0x00003ffe,
  0x00000001, 0x00003fef, 0x00003ffe, 0x00003fff,
  0x00003fc0, 0x00003fef, 0x00003ffe, 0x19999999,
  0x00003fc1, 0x00003ff0, 0x19999998, 0x2aaaaaaa,
  0x00003fc1, 0x1999998a, 0x2aaaaaa9, 0x3ffffffe,
  0x1999995b, 0x2aaaaa9b, 0x3ffffffd, 0x3ffffffe,
  0x2aaaaa6c, 0x3fffffef, 0x3ffffffe, 0x3fffffff,
  0x3fffffc0, 0x3fffffef, 0x3ffffffe, 0xbfffffff,
  0x3fffffc1, 0x3ffffff0, 0xbfffffff, 0xc0000000,
  0x3fffffc1, 0xbffffff0, 0xbfffffff, 0xd5555554,
  0xbfffffc2, 0xbffffff1, 0xd5555554, 0xe6666665,
  0xbfffffc2, 0xd5555545, 0xe6666665, 0xffffbfff,
  0xd5555517, 0xe6666656, 0xffffbfff, 0xffffc000,
  0xe6666628, 0xffffbff0, 0xffffbfff, 0xffffc000,
  0xffffbfc2, 0xffffbff1, 0xffffc000, 0xffffc001,
  0xffffbfc2, 0xffffbff1, 0xffffc000, 0xffffffbf,
  0xffffbfc3, 0xffffbff2, 0xffffffbf, 0xffffffc0,
  0xffffbfc3, 0xffffffb0, 0xffffffbf, 0xffffffc0,
  0xffffff82, 0xffffffb1, 0xffffffc0, 0xffffffc1,
  0xffffff82, 0xffffffb1, 0xffffffc0, 0xffffffef,
  0xffffff83, 0xffffffb2, 0xffffffef, 0xfffffffe,
  0xffffff83, 0xffffffe0, 0xfffffffd, 0xfffffffe,
  0xffffffb2, 0xffffffef, 0xfffffffe, 0xffffffff,
  0xffffffef, 0xfffffffe, 0xffffffff, 0x00000000,
  0xffffffef, 0xfffffffe, 0xffffffff, 0x00000000,
  0xfffffff0, 0xffffffff, 0x00000000, 0x00000001,
  0xfffffff0, 0xffffffff, 0x00000000, 0x00000010,
  0xfffffff1, 0x00000000, 0x0000000f, 0x0000003e,
  0xfffffff1, 0x0000000f, 0x0000003e, 0x0000003f,
  0x00000000, 0x0000003d, 0x0000003e, 0x0000003f,
  0x0000002f, 0x0000003e, 0x0000003f, 0x00003ffe,
  0x0000002f, 0x0000003e, 0x00003ffe, 0x00003fff,
  0x00000030, 0x00003ffd, 0x00003ffe, 0x00003fff,
  0x00003fef, 0x00003ffe, 0x00003fff, 0x19999999,
  0x00003fef, 0x00003ffe, 0x19999999, 0x2aaaaaaa,
  0x00003ff0, 0x19999998, 0x2aaaaaaa, 0x3ffffffe,
  0x1999998a, 0x2aaaaaa9, 0x3ffffffe, 0x3fffffff,
  0x2aaaaa9b, 0x3ffffffd, 0x3ffffffe, 0x3fffffff,
  0x3fffffef, 0x3ffffffe, 0x3fffffff, 0xc0000000,
  0x3fffffef, 0x3ffffffe, 0xbfffffff, 0xc0000000,
  0x3ffffff0, 0xbfffffff, 0xc0000000, 0xd5555555,
  0xbffffff0, 0xbfffffff, 0xd5555554, 0xe6666666,
  0xbffffff1, 0xd5555554, 0xe6666665, 0xffffc000,
  0xd5555545, 0xe6666665, 0xffffbfff, 0xffffc000,
  0xe6666656, 0xffffbfff, 0xffffc000, 0xffffc001,
  0xffffbff0, 0xffffbfff, 0xffffc000, 0xffffc001,
  0xffffbff1, 0xffffc000, 0xffffc001, 0xffffffc0,
  0xffffbff1, 0xffffc000, 0xffffffbf, 0xffffffc0,
  0xffffbff2, 0xffffffbf, 0xffffffc0, 0xffffffc1,
  0xffffffb0, 0xffffffbf, 0xffffffc0, 0xffffffc1,
  0xffffffb1, 0xffffffc0, 0xffffffc1, 0xfffffff0,
  0xffffffb1, 0xffffffc0, 0xffffffef, 0xfffffffe,
  0xffffffb2, 0xffffffef, 0xfffffffe, 0xffffffff,
  0xffffffe0, 0xfffffffd, 0xfffffffe, 0xffffffff,
};
const unsigned kExpectedCount_NEON_srhadd_4S = 961;

#endif  // VIXL_SIM_SRHADD_4S_TRACE_AARCH64_H_
