/*
 * Copyright 2018-2019, Intel Corporation
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in
 *       the documentation and/or other materials provided with the
 *       distribution.
 *
 *     * Neither the name of the copyright holder nor the names of its
 *       contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef CRITNIB_H
#define CRITNIB_H

#include "vmemcache.h"
#include "os_thread.h"

/*
 * SLICE may be 1, 2, 4 or 8.  1 or 8 could be further optimized (critbit
 * and critbyte respectively); 4 (critnib) strikes a good balance between
 * speed and memory use.
 */
#define SLICE 4
#define SLNODES (1 << SLICE)

typedef uint32_t byten_t;
typedef unsigned char bitn_t;

struct critnib_node {
	struct critnib_node *child[SLNODES];
	byten_t byte;
	bitn_t bit;
};

struct critnib {
	struct critnib_node *root;
	os_rwlock_t lock;
	size_t leaf_count; /* entries */
	size_t node_count; /* internal nodes only */
	size_t DRAM_usage; /* ... of leaves (nodes are constant-sized) */
	/* operation counts */
	size_t put_count;
	size_t evict_count;
	size_t hit_count;
	size_t miss_count;
};

struct cache_entry;

struct critnib *critnib_new(void);
void critnib_delete(struct critnib *c, delete_entry_t del);
int critnib_set(struct critnib *c, struct cache_entry *e);
void *critnib_get(struct critnib *c, const struct cache_entry *e);
void *critnib_remove(struct critnib *c, const struct cache_entry *e);

#endif
