# Volatility
# Copyright (c) 2008-2013 Volatility Foundation
# Copyright (c) 2011 Michael Hale Ligh <michael.hale@gmail.com>
#
# This file is part of Volatility.
#
# Volatility is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License Version 2 as
# published by the Free Software Foundation.  You may not use, modify or
# distribute this program under any other version of the GNU General
# Public License.
#
# Volatility is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Volatility.  If not, see <http://www.gnu.org/licenses/>.
#

syscalls = [
    [
    'NtAcceptConnectPort', # 0x0
    'NtAccessCheck', # 0x1
    'NtAccessCheckAndAuditAlarm', # 0x2
    'NtAccessCheckByType', # 0x3
    'NtAccessCheckByTypeAndAuditAlarm', # 0x4
    'NtAccessCheckByTypeResultList', # 0x5
    'NtAccessCheckByTypeResultListAndAuditAlarm', # 0x6
    'NtAccessCheckByTypeResultListAndAuditAlarmByHandle', # 0x7
    'NtAddAtom', # 0x8
    'NtAddBootEntry', # 0x9
    'NtAddDriverEntry', # 0xa
    'NtAdjustGroupsToken', # 0xb
    'NtAdjustPrivilegesToken', # 0xc
    'NtAlertResumeThread', # 0xd
    'NtAlertThread', # 0xe
    'NtAllocateLocallyUniqueId', # 0xf
    'NtAllocateReserveObject', # 0x10
    'NtAllocateUserPhysicalPages', # 0x11
    'NtAllocateUuids', # 0x12
    'NtAllocateVirtualMemory', # 0x13
    'NtAlpcAcceptConnectPort', # 0x14
    'NtAlpcCancelMessage', # 0x15
    'NtAlpcConnectPort', # 0x16
    'NtAlpcCreatePort', # 0x17
    'NtAlpcCreatePortSection', # 0x18
    'NtAlpcCreateResourceReserve', # 0x19
    'NtAlpcCreateSectionView', # 0x1a
    'NtAlpcCreateSecurityContext', # 0x1b
    'NtAlpcDeletePortSection', # 0x1c
    'NtAlpcDeleteResourceReserve', # 0x1d
    'NtAlpcDeleteSectionView', # 0x1e
    'NtAlpcDeleteSecurityContext', # 0x1f
    'NtAlpcDisconnectPort', # 0x20
    'NtAlpcImpersonateClientOfPort', # 0x21
    'NtAlpcOpenSenderProcess', # 0x22
    'NtAlpcOpenSenderThread', # 0x23
    'NtAlpcQueryInformation', # 0x24
    'NtAlpcQueryInformationMessage', # 0x25
    'NtAlpcRevokeSecurityContext', # 0x26
    'NtAlpcSendWaitReceivePort', # 0x27
    'NtAlpcSetInformation', # 0x28
    'NtApphelpCacheControl', # 0x29
    'NtAreMappedFilesTheSame', # 0x2a
    'NtAssignProcessToJobObject', # 0x2b
    'NtCallbackReturn', # 0x2c
    'NtCancelIoFile', # 0x2d
    'NtCancelIoFileEx', # 0x2e
    'NtCancelSynchronousIoFile', # 0x2f
    'NtCancelTimer', # 0x30
    'NtClearEvent', # 0x31
    'NtClose', # 0x32
    'NtCloseObjectAuditAlarm', # 0x33
    'NtCommitComplete', # 0x34
    'NtCommitEnlistment', # 0x35
    'NtCommitTransaction', # 0x36
    'NtCompactKeys', # 0x37
    'NtCompareTokens', # 0x38
    'NtCompleteConnectPort', # 0x39
    'NtCompressKey', # 0x3a
    'NtConnectPort', # 0x3b
    'NtContinue', # 0x3c
    'NtCreateDebugObject', # 0x3d
    'NtCreateDirectoryObject', # 0x3e
    'NtCreateEnlistment', # 0x3f
    'NtCreateEvent', # 0x40
    'NtCreateEventPair', # 0x41
    'NtCreateFile', # 0x42
    'NtCreateIoCompletion', # 0x43
    'NtCreateJobObject', # 0x44
    'NtCreateJobSet', # 0x45
    'NtCreateKey', # 0x46
    'NtCreateKeyedEvent', # 0x47
    'NtCreateKeyTransacted', # 0x48
    'NtCreateMailslotFile', # 0x49
    'NtCreateMutant', # 0x4a
    'NtCreateNamedPipeFile', # 0x4b
    'NtCreatePagingFile', # 0x4c
    'NtCreatePort', # 0x4d
    'NtCreatePrivateNamespace', # 0x4e
    'NtCreateProcess', # 0x4f
    'NtCreateProcessEx', # 0x50
    'NtCreateProfile', # 0x51
    'NtCreateProfileEx', # 0x52
    'NtCreateResourceManager', # 0x53
    'NtCreateSection', # 0x54
    'NtCreateSemaphore', # 0x55
    'NtCreateSymbolicLinkObject', # 0x56
    'NtCreateThread', # 0x57
    'NtCreateThreadEx', # 0x58
    'NtCreateTimer', # 0x59
    'NtCreateToken', # 0x5a
    'NtCreateTransaction', # 0x5b
    'NtCreateTransactionManager', # 0x5c
    'NtCreateUserProcess', # 0x5d
    'NtCreateWaitablePort', # 0x5e
    'NtCreateWorkerFactory', # 0x5f
    'NtDebugActiveProcess', # 0x60
    'NtDebugContinue', # 0x61
    'NtDelayExecution', # 0x62
    'NtDeleteAtom', # 0x63
    'NtDeleteBootEntry', # 0x64
    'NtDeleteDriverEntry', # 0x65
    'NtDeleteFile', # 0x66
    'NtDeleteKey', # 0x67
    'NtDeleteObjectAuditAlarm', # 0x68
    'NtDeletePrivateNamespace', # 0x69
    'NtDeleteValueKey', # 0x6a
    'NtDeviceIoControlFile', # 0x6b
    'NtDisableLastKnownGood', # 0x6c
    'NtDisplayString', # 0x6d
    'NtDrawText', # 0x6e
    'NtDuplicateObject', # 0x6f
    'NtDuplicateToken', # 0x70
    'NtEnableLastKnownGood', # 0x71
    'NtEnumerateBootEntries', # 0x72
    'NtEnumerateDriverEntries', # 0x73
    'NtEnumerateKey', # 0x74
    'NtEnumerateSystemEnvironmentValuesEx', # 0x75
    'NtEnumerateTransactionObject', # 0x76
    'NtEnumerateValueKey', # 0x77
    'NtExtendSection', # 0x78
    'NtFilterToken', # 0x79
    'NtFindAtom', # 0x7a
    'NtFlushBuffersFile', # 0x7b
    'NtFlushInstallUILanguage', # 0x7c
    'NtFlushInstructionCache', # 0x7d
    'NtFlushKey', # 0x7e
    'NtFlushProcessWriteBuffers', # 0x7f
    'NtFlushVirtualMemory', # 0x80
    'NtFlushWriteBuffer', # 0x81
    'NtFreeUserPhysicalPages', # 0x82
    'NtFreeVirtualMemory', # 0x83
    'NtFreezeRegistry', # 0x84
    'NtFreezeTransactions', # 0x85
    'NtFsControlFile', # 0x86
    'NtGetContextThread', # 0x87
    'NtGetCurrentProcessorNumber', # 0x88
    'NtGetDevicePowerState', # 0x89
    'NtGetMUIRegistryInfo', # 0x8a
    'NtGetNextProcess', # 0x8b
    'NtGetNextThread', # 0x8c
    'NtGetNlsSectionPtr', # 0x8d
    'NtGetNotificationResourceManager', # 0x8e
    'NtGetPlugPlayEvent', # 0x8f
    'NtGetWriteWatch', # 0x90
    'NtImpersonateAnonymousToken', # 0x91
    'NtImpersonateClientOfPort', # 0x92
    'NtImpersonateThread', # 0x93
    'NtInitializeNlsFiles', # 0x94
    'NtInitializeRegistry', # 0x95
    'NtInitiatePowerAction', # 0x96
    'NtIsProcessInJob', # 0x97
    'NtIsSystemResumeAutomatic', # 0x98
    'NtIsUILanguageComitted', # 0x99
    'NtListenPort', # 0x9a
    'NtLoadDriver', # 0x9b
    'NtLoadKey', # 0x9c
    'NtLoadKey2', # 0x9d
    'NtLoadKeyEx', # 0x9e
    'NtLockFile', # 0x9f
    'NtLockProductActivationKeys', # 0xa0
    'NtLockRegistryKey', # 0xa1
    'NtLockVirtualMemory', # 0xa2
    'NtMakePermanentObject', # 0xa3
    'NtMakeTemporaryObject', # 0xa4
    'NtMapCMFModule', # 0xa5
    'NtMapUserPhysicalPages', # 0xa6
    'NtMapUserPhysicalPagesScatter', # 0xa7
    'NtMapViewOfSection', # 0xa8
    'NtModifyBootEntry', # 0xa9
    'NtModifyDriverEntry', # 0xaa
    'NtNotifyChangeDirectoryFile', # 0xab
    'NtNotifyChangeKey', # 0xac
    'NtNotifyChangeMultipleKeys', # 0xad
    'NtNotifyChangeSession', # 0xae
    'NtOpenDirectoryObject', # 0xaf
    'NtOpenEnlistment', # 0xb0
    'NtOpenEvent', # 0xb1
    'NtOpenEventPair', # 0xb2
    'NtOpenFile', # 0xb3
    'NtOpenIoCompletion', # 0xb4
    'NtOpenJobObject', # 0xb5
    'NtOpenKey', # 0xb6
    'NtOpenKeyEx', # 0xb7
    'NtOpenKeyedEvent', # 0xb8
    'NtOpenKeyTransacted', # 0xb9
    'NtOpenKeyTransactedEx', # 0xba
    'NtOpenMutant', # 0xbb
    'NtOpenObjectAuditAlarm', # 0xbc
    'NtOpenPrivateNamespace', # 0xbd
    'NtOpenProcess', # 0xbe
    'NtOpenProcessToken', # 0xbf
    'NtOpenProcessTokenEx', # 0xc0
    'NtOpenResourceManager', # 0xc1
    'NtOpenSection', # 0xc2
    'NtOpenSemaphore', # 0xc3
    'NtOpenSession', # 0xc4
    'NtOpenSymbolicLinkObject', # 0xc5
    'NtOpenThread', # 0xc6
    'NtOpenThreadToken', # 0xc7
    'NtOpenThreadTokenEx', # 0xc8
    'NtOpenTimer', # 0xc9
    'NtOpenTransaction', # 0xca
    'NtOpenTransactionManager', # 0xcb
    'NtPlugPlayControl', # 0xcc
    'NtPowerInformation', # 0xcd
    'NtPrepareComplete', # 0xce
    'NtPrepareEnlistment', # 0xcf
    'NtPrePrepareComplete', # 0xd0
    'NtPrePrepareEnlistment', # 0xd1
    'NtPrivilegeCheck', # 0xd2
    'NtPrivilegedServiceAuditAlarm', # 0xd3
    'NtPrivilegeObjectAuditAlarm', # 0xd4
    'NtPropagationComplete', # 0xd5
    'NtPropagationFailed', # 0xd6
    'NtProtectVirtualMemory', # 0xd7
    'NtPulseEvent', # 0xd8
    'NtQueryAttributesFile', # 0xd9
    'NtQueryBootEntryOrder', # 0xda
    'NtQueryBootOptions', # 0xdb
    'NtQueryDebugFilterState', # 0xdc
    'NtQueryDefaultLocale', # 0xdd
    'NtQueryDefaultUILanguage', # 0xde
    'NtQueryDirectoryFile', # 0xdf
    'NtQueryDirectoryObject', # 0xe0
    'NtQueryDriverEntryOrder', # 0xe1
    'NtQueryEaFile', # 0xe2
    'NtQueryEvent', # 0xe3
    'NtQueryFullAttributesFile', # 0xe4
    'NtQueryInformationAtom', # 0xe5
    'NtQueryInformationEnlistment', # 0xe6
    'NtQueryInformationFile', # 0xe7
    'NtQueryInformationJobObject', # 0xe8
    'NtQueryInformationPort', # 0xe9
    'NtQueryInformationProcess', # 0xea
    'NtQueryInformationResourceManager', # 0xeb
    'NtQueryInformationThread', # 0xec
    'NtQueryInformationToken', # 0xed
    'NtQueryInformationTransaction', # 0xee
    'NtQueryInformationTransactionManager', # 0xef
    'NtQueryInformationWorkerFactory', # 0xf0
    'NtQueryInstallUILanguage', # 0xf1
    'NtQueryIntervalProfile', # 0xf2
    'NtQueryIoCompletion', # 0xf3
    'NtQueryKey', # 0xf4
    'NtQueryLicenseValue', # 0xf5
    'NtQueryMultipleValueKey', # 0xf6
    'NtQueryMutant', # 0xf7
    'NtQueryObject', # 0xf8
    'NtQueryOpenSubKeys', # 0xf9
    'NtQueryOpenSubKeysEx', # 0xfa
    'NtQueryPerformanceCounter', # 0xfb
    'NtQueryPortInformationProcess', # 0xfc
    'NtQueryQuotaInformationFile', # 0xfd
    'NtQuerySection', # 0xfe
    'NtQuerySecurityAttributesToken', # 0xff
    'NtQuerySecurityObject', # 0x100
    'NtQuerySemaphore', # 0x101
    'NtQuerySymbolicLinkObject', # 0x102
    'NtQuerySystemEnvironmentValue', # 0x103
    'NtQuerySystemEnvironmentValueEx', # 0x104
    'NtQuerySystemInformation', # 0x105
    'NtQuerySystemInformationEx', # 0x106
    'NtQuerySystemTime', # 0x107
    'NtQueryTimer', # 0x108
    'NtQueryTimerResolution', # 0x109
    'NtQueryValueKey', # 0x10a
    'NtQueryVirtualMemory', # 0x10b
    'NtQueryVolumeInformationFile', # 0x10c
    'NtQueueApcThread', # 0x10d
    'NtQueueApcThreadEx', # 0x10e
    'NtRaiseException', # 0x10f
    'NtRaiseHardError', # 0x110
    'NtReadFile', # 0x111
    'NtReadFileScatter', # 0x112
    'NtReadOnlyEnlistment', # 0x113
    'NtReadRequestData', # 0x114
    'NtReadVirtualMemory', # 0x115
    'NtRecoverEnlistment', # 0x116
    'NtRecoverResourceManager', # 0x117
    'NtRecoverTransactionManager', # 0x118
    'NtRegisterProtocolAddressInformation', # 0x119
    'NtRegisterThreadTerminatePort', # 0x11a
    'NtReleaseKeyedEvent', # 0x11b
    'NtReleaseMutant', # 0x11c
    'NtReleaseSemaphore', # 0x11d
    'NtReleaseWorkerFactoryWorker', # 0x11e
    'NtRemoveIoCompletion', # 0x11f
    'NtRemoveIoCompletionEx', # 0x120
    'NtRemoveProcessDebug', # 0x121
    'NtRenameKey', # 0x122
    'NtRenameTransactionManager', # 0x123
    'NtReplaceKey', # 0x124
    'NtReplacePartitionUnit', # 0x125
    'NtReplyPort', # 0x126
    'NtReplyWaitReceivePort', # 0x127
    'NtReplyWaitReceivePortEx', # 0x128
    'NtReplyWaitReplyPort', # 0x129
    'NtRequestPort', # 0x12a
    'NtRequestWaitReplyPort', # 0x12b
    'NtResetEvent', # 0x12c
    'NtResetWriteWatch', # 0x12d
    'NtRestoreKey', # 0x12e
    'NtResumeProcess', # 0x12f
    'NtResumeThread', # 0x130
    'NtRollbackComplete', # 0x131
    'NtRollbackEnlistment', # 0x132
    'NtRollbackTransaction', # 0x133
    'NtRollforwardTransactionManager', # 0x134
    'NtSaveKey', # 0x135
    'NtSaveKeyEx', # 0x136
    'NtSaveMergedKeys', # 0x137
    'NtSecureConnectPort', # 0x138
    'NtSerializeBoot', # 0x139
    'NtSetBootEntryOrder', # 0x13a
    'NtSetBootOptions', # 0x13b
    'NtSetContextThread', # 0x13c
    'NtSetDebugFilterState', # 0x13d
    'NtSetDefaultHardErrorPort', # 0x13e
    'NtSetDefaultLocale', # 0x13f
    'NtSetDefaultUILanguage', # 0x140
    'NtSetDriverEntryOrder', # 0x141
    'NtSetEaFile', # 0x142
    'NtSetEvent', # 0x143
    'NtSetEventBoostPriority', # 0x144
    'NtSetHighEventPair', # 0x145
    'NtSetHighWaitLowEventPair', # 0x146
    'NtSetInformationDebugObject', # 0x147
    'NtSetInformationEnlistment', # 0x148
    'NtSetInformationFile', # 0x149
    'NtSetInformationJobObject', # 0x14a
    'NtSetInformationKey', # 0x14b
    'NtSetInformationObject', # 0x14c
    'NtSetInformationProcess', # 0x14d
    'NtSetInformationResourceManager', # 0x14e
    'NtSetInformationThread', # 0x14f
    'NtSetInformationToken', # 0x150
    'NtSetInformationTransaction', # 0x151
    'NtSetInformationTransactionManager', # 0x152
    'NtSetInformationWorkerFactory', # 0x153
    'NtSetIntervalProfile', # 0x154
    'NtSetIoCompletion', # 0x155
    'NtSetIoCompletionEx', # 0x156
    'NtSetLdtEntries', # 0x157
    'NtSetLowEventPair', # 0x158
    'NtSetLowWaitHighEventPair', # 0x159
    'NtSetQuotaInformationFile', # 0x15a
    'NtSetSecurityObject', # 0x15b
    'NtSetSystemEnvironmentValue', # 0x15c
    'NtSetSystemEnvironmentValueEx', # 0x15d
    'NtSetSystemInformation', # 0x15e
    'NtSetSystemPowerState', # 0x15f
    'NtSetSystemTime', # 0x160
    'NtSetThreadExecutionState', # 0x161
    'NtSetTimer', # 0x162
    'NtSetTimerEx', # 0x163
    'NtSetTimerResolution', # 0x164
    'NtSetUuidSeed', # 0x165
    'NtSetValueKey', # 0x166
    'NtSetVolumeInformationFile', # 0x167
    'NtShutdownSystem', # 0x168
    'NtShutdownWorkerFactory', # 0x169
    'NtSignalAndWaitForSingleObject', # 0x16a
    'NtSinglePhaseReject', # 0x16b
    'NtStartProfile', # 0x16c
    'NtStopProfile', # 0x16d
    'NtSuspendProcess', # 0x16e
    'NtSuspendThread', # 0x16f
    'NtSystemDebugControl', # 0x170
    'NtTerminateJobObject', # 0x171
    'NtTerminateProcess', # 0x172
    'NtTerminateThread', # 0x173
    'NtTestAlert', # 0x174
    'NtThawRegistry', # 0x175
    'NtThawTransactions', # 0x176
    'NtTraceControl', # 0x177
    'NtTraceEvent', # 0x178
    'NtTranslateFilePath', # 0x179
    'NtUmsThreadYield', # 0x17a
    'NtUnloadDriver', # 0x17b
    'NtUnloadKey', # 0x17c
    'NtUnloadKey2', # 0x17d
    'NtUnloadKeyEx', # 0x17e
    'NtUnlockFile', # 0x17f
    'NtUnlockVirtualMemory', # 0x180
    'NtUnmapViewOfSection', # 0x181
    'NtVdmControl', # 0x182
    'NtWaitForDebugEvent', # 0x183
    'NtWaitForKeyedEvent', # 0x184
    'NtWaitForMultipleObjects', # 0x185
    'NtWaitForMultipleObjects32', # 0x186
    'NtWaitForSingleObject', # 0x187
    'NtWaitForWorkViaWorkerFactory', # 0x188
    'NtWaitHighEventPair', # 0x189
    'NtWaitLowEventPair', # 0x18a
    'NtWorkerFactoryWorkerReady', # 0x18b
    'NtWriteFile', # 0x18c
    'NtWriteFileGather', # 0x18d
    'NtWriteRequestData', # 0x18e
    'NtWriteVirtualMemory', # 0x18f
    'NtYieldExecution', # 0x190
    ],
    [
    'NtGdiAbortDoc', # 0x0
    'NtGdiAbortPath', # 0x1
    'NtGdiAddFontResourceW', # 0x2
    'NtGdiAddRemoteFontToDC', # 0x3
    'NtGdiAddFontMemResourceEx', # 0x4
    'NtGdiRemoveMergeFont', # 0x5
    'NtGdiAddRemoteMMInstanceToDC', # 0x6
    'NtGdiAlphaBlend', # 0x7
    'NtGdiAngleArc', # 0x8
    'NtGdiAnyLinkedFonts', # 0x9
    'NtGdiFontIsLinked', # 0xa
    'NtGdiArcInternal', # 0xb
    'NtGdiBeginGdiRendering', # 0xc
    'NtGdiBeginPath', # 0xd
    'NtGdiBitBlt', # 0xe
    'NtGdiCancelDC', # 0xf
    'NtGdiCheckBitmapBits', # 0x10
    'NtGdiCloseFigure', # 0x11
    'NtGdiClearBitmapAttributes', # 0x12
    'NtGdiClearBrushAttributes', # 0x13
    'NtGdiColorCorrectPalette', # 0x14
    'NtGdiCombineRgn', # 0x15
    'NtGdiCombineTransform', # 0x16
    'NtGdiComputeXformCoefficients', # 0x17
    'NtGdiConfigureOPMProtectedOutput', # 0x18
    'NtGdiConvertMetafileRect', # 0x19
    'NtGdiCreateBitmap', # 0x1a
    'NtGdiCreateBitmapFromDxSurface', # 0x1b
    'NtGdiCreateClientObj', # 0x1c
    'NtGdiCreateColorSpace', # 0x1d
    'NtGdiCreateColorTransform', # 0x1e
    'NtGdiCreateCompatibleBitmap', # 0x1f
    'NtGdiCreateCompatibleDC', # 0x20
    'NtGdiCreateDIBBrush', # 0x21
    'NtGdiCreateDIBitmapInternal', # 0x22
    'NtGdiCreateDIBSection', # 0x23
    'NtGdiCreateEllipticRgn', # 0x24
    'NtGdiCreateHalftonePalette', # 0x25
    'NtGdiCreateHatchBrushInternal', # 0x26
    'NtGdiCreateMetafileDC', # 0x27
    'NtGdiCreateOPMProtectedOutputs', # 0x28
    'NtGdiCreatePaletteInternal', # 0x29
    'NtGdiCreatePatternBrushInternal', # 0x2a
    'NtGdiCreatePen', # 0x2b
    'NtGdiCreateRectRgn', # 0x2c
    'NtGdiCreateRoundRectRgn', # 0x2d
    'NtGdiCreateServerMetaFile', # 0x2e
    'NtGdiCreateSolidBrush', # 0x2f
    'NtGdiD3dContextCreate', # 0x30
    'NtGdiD3dContextDestroy', # 0x31
    'NtGdiD3dContextDestroyAll', # 0x32
    'NtGdiD3dValidateTextureStageState', # 0x33
    'NtGdiD3dDrawPrimitives2', # 0x34
    'NtGdiDdGetDriverState', # 0x35
    'NtGdiDdAddAttachedSurface', # 0x36
    'NtGdiDdAlphaBlt', # 0x37
    'NtGdiDdAttachSurface', # 0x38
    'NtGdiDdBeginMoCompFrame', # 0x39
    'NtGdiDdBlt', # 0x3a
    'NtGdiDdCanCreateSurface', # 0x3b
    'NtGdiDdCanCreateD3DBuffer', # 0x3c
    'NtGdiDdColorControl', # 0x3d
    'NtGdiDdCreateDirectDrawObject', # 0x3e
    'NtGdiDdCreateSurface', # 0x3f
    'NtGdiDdCreateD3DBuffer', # 0x40
    'NtGdiDdCreateMoComp', # 0x41
    'NtGdiDdCreateSurfaceObject', # 0x42
    'NtGdiDdDeleteDirectDrawObject', # 0x43
    'NtGdiDdDeleteSurfaceObject', # 0x44
    'NtGdiDdDestroyMoComp', # 0x45
    'NtGdiDdDestroySurface', # 0x46
    'NtGdiDdDestroyD3DBuffer', # 0x47
    'NtGdiDdEndMoCompFrame', # 0x48
    'NtGdiDdFlip', # 0x49
    'NtGdiDdFlipToGDISurface', # 0x4a
    'NtGdiDdGetAvailDriverMemory', # 0x4b
    'NtGdiDdGetBltStatus', # 0x4c
    'NtGdiDdGetDC', # 0x4d
    'NtGdiDdGetDriverInfo', # 0x4e
    'NtGdiDdGetDxHandle', # 0x4f
    'NtGdiDdGetFlipStatus', # 0x50
    'NtGdiDdGetInternalMoCompInfo', # 0x51
    'NtGdiDdGetMoCompBuffInfo', # 0x52
    'NtGdiDdGetMoCompGuids', # 0x53
    'NtGdiDdGetMoCompFormats', # 0x54
    'NtGdiDdGetScanLine', # 0x55
    'NtGdiDdLock', # 0x56
    'NtGdiDdLockD3D', # 0x57
    'NtGdiDdQueryDirectDrawObject', # 0x58
    'NtGdiDdQueryMoCompStatus', # 0x59
    'NtGdiDdReenableDirectDrawObject', # 0x5a
    'NtGdiDdReleaseDC', # 0x5b
    'NtGdiDdRenderMoComp', # 0x5c
    'NtGdiDdResetVisrgn', # 0x5d
    'NtGdiDdSetColorKey', # 0x5e
    'NtGdiDdSetExclusiveMode', # 0x5f
    'NtGdiDdSetGammaRamp', # 0x60
    'NtGdiDdCreateSurfaceEx', # 0x61
    'NtGdiDdSetOverlayPosition', # 0x62
    'NtGdiDdUnattachSurface', # 0x63
    'NtGdiDdUnlock', # 0x64
    'NtGdiDdUnlockD3D', # 0x65
    'NtGdiDdUpdateOverlay', # 0x66
    'NtGdiDdWaitForVerticalBlank', # 0x67
    'NtGdiDvpCanCreateVideoPort', # 0x68
    'NtGdiDvpColorControl', # 0x69
    'NtGdiDvpCreateVideoPort', # 0x6a
    'NtGdiDvpDestroyVideoPort', # 0x6b
    'NtGdiDvpFlipVideoPort', # 0x6c
    'NtGdiDvpGetVideoPortBandwidth', # 0x6d
    'NtGdiDvpGetVideoPortField', # 0x6e
    'NtGdiDvpGetVideoPortFlipStatus', # 0x6f
    'NtGdiDvpGetVideoPortInputFormats', # 0x70
    'NtGdiDvpGetVideoPortLine', # 0x71
    'NtGdiDvpGetVideoPortOutputFormats', # 0x72
    'NtGdiDvpGetVideoPortConnectInfo', # 0x73
    'NtGdiDvpGetVideoSignalStatus', # 0x74
    'NtGdiDvpUpdateVideoPort', # 0x75
    'NtGdiDvpWaitForVideoPortSync', # 0x76
    'NtGdiDvpAcquireNotification', # 0x77
    'NtGdiDvpReleaseNotification', # 0x78
    'NtGdiDxgGenericThunk', # 0x79
    'NtGdiDeleteClientObj', # 0x7a
    'NtGdiDeleteColorSpace', # 0x7b
    'NtGdiDeleteColorTransform', # 0x7c
    'NtGdiDeleteObjectApp', # 0x7d
    'NtGdiDescribePixelFormat', # 0x7e
    'NtGdiDestroyOPMProtectedOutput', # 0x7f
    'NtGdiGetPerBandInfo', # 0x80
    'NtGdiDoBanding', # 0x81
    'NtGdiDoPalette', # 0x82
    'NtGdiDrawEscape', # 0x83
    'NtGdiEllipse', # 0x84
    'NtGdiEnableEudc', # 0x85
    'NtGdiEndDoc', # 0x86
    'NtGdiEndGdiRendering', # 0x87
    'NtGdiEndPage', # 0x88
    'NtGdiEndPath', # 0x89
    'NtGdiEnumFonts', # 0x8a
    'NtGdiEnumObjects', # 0x8b
    'NtGdiEqualRgn', # 0x8c
    'NtGdiEudcLoadUnloadLink', # 0x8d
    'NtGdiExcludeClipRect', # 0x8e
    'NtGdiExtCreatePen', # 0x8f
    'NtGdiExtCreateRegion', # 0x90
    'NtGdiExtEscape', # 0x91
    'NtGdiExtFloodFill', # 0x92
    'NtGdiExtGetObjectW', # 0x93
    'NtGdiExtSelectClipRgn', # 0x94
    'NtGdiExtTextOutW', # 0x95
    'NtGdiFillPath', # 0x96
    'NtGdiFillRgn', # 0x97
    'NtGdiFlattenPath', # 0x98
    'NtGdiFlush', # 0x99
    'NtGdiForceUFIMapping', # 0x9a
    'NtGdiFrameRgn', # 0x9b
    'NtGdiFullscreenControl', # 0x9c
    'NtGdiGetAndSetDCDword', # 0x9d
    'NtGdiGetAppClipBox', # 0x9e
    'NtGdiGetBitmapBits', # 0x9f
    'NtGdiGetBitmapDimension', # 0xa0
    'NtGdiGetBoundsRect', # 0xa1
    'NtGdiGetCertificate', # 0xa2
    'NtGdiGetCertificateSize', # 0xa3
    'NtGdiGetCharABCWidthsW', # 0xa4
    'NtGdiGetCharacterPlacementW', # 0xa5
    'NtGdiGetCharSet', # 0xa6
    'NtGdiGetCharWidthW', # 0xa7
    'NtGdiGetCharWidthInfo', # 0xa8
    'NtGdiGetColorAdjustment', # 0xa9
    'NtGdiGetColorSpaceforBitmap', # 0xaa
    'NtGdiGetCOPPCompatibleOPMInformation', # 0xab
    'NtGdiGetDCDword', # 0xac
    'NtGdiGetDCforBitmap', # 0xad
    'NtGdiGetDCObject', # 0xae
    'NtGdiGetDCPoint', # 0xaf
    'NtGdiGetDeviceCaps', # 0xb0
    'NtGdiGetDeviceGammaRamp', # 0xb1
    'NtGdiGetDeviceCapsAll', # 0xb2
    'NtGdiGetDIBitsInternal', # 0xb3
    'NtGdiGetETM', # 0xb4
    'NtGdiGetEudcTimeStampEx', # 0xb5
    'NtGdiGetFontData', # 0xb6
    'NtGdiGetFontFileData', # 0xb7
    'NtGdiGetFontFileInfo', # 0xb8
    'NtGdiGetFontResourceInfoInternalW', # 0xb9
    'NtGdiGetGlyphIndicesW', # 0xba
    'NtGdiGetGlyphIndicesWInternal', # 0xbb
    'NtGdiGetGlyphOutline', # 0xbc
    'NtGdiGetOPMInformation', # 0xbd
    'NtGdiGetKerningPairs', # 0xbe
    'NtGdiGetLinkedUFIs', # 0xbf
    'NtGdiGetMiterLimit', # 0xc0
    'NtGdiGetMonitorID', # 0xc1
    'NtGdiGetNearestColor', # 0xc2
    'NtGdiGetNearestPaletteIndex', # 0xc3
    'NtGdiGetObjectBitmapHandle', # 0xc4
    'NtGdiGetOPMRandomNumber', # 0xc5
    'NtGdiGetOutlineTextMetricsInternalW', # 0xc6
    'NtGdiGetPath', # 0xc7
    'NtGdiGetPixel', # 0xc8
    'NtGdiGetRandomRgn', # 0xc9
    'NtGdiGetRasterizerCaps', # 0xca
    'NtGdiGetRealizationInfo', # 0xcb
    'NtGdiGetRegionData', # 0xcc
    'NtGdiGetRgnBox', # 0xcd
    'NtGdiGetServerMetaFileBits', # 0xce
    'NtGdiGetSpoolMessage', # 0xcf
    'NtGdiGetStats', # 0xd0
    'NtGdiGetStockObject', # 0xd1
    'NtGdiGetStringBitmapW', # 0xd2
    'NtGdiGetSuggestedOPMProtectedOutputArraySize', # 0xd3
    'NtGdiGetSystemPaletteUse', # 0xd4
    'NtGdiGetTextCharsetInfo', # 0xd5
    'NtGdiGetTextExtent', # 0xd6
    'NtGdiGetTextExtentExW', # 0xd7
    'NtGdiGetTextFaceW', # 0xd8
    'NtGdiGetTextMetricsW', # 0xd9
    'NtGdiGetTransform', # 0xda
    'NtGdiGetUFI', # 0xdb
    'NtGdiGetEmbUFI', # 0xdc
    'NtGdiGetUFIPathname', # 0xdd
    'NtGdiGetEmbedFonts', # 0xde
    'NtGdiChangeGhostFont', # 0xdf
    'NtGdiAddEmbFontToDC', # 0xe0
    'NtGdiGetFontUnicodeRanges', # 0xe1
    'NtGdiGetWidthTable', # 0xe2
    'NtGdiGradientFill', # 0xe3
    'NtGdiHfontCreate', # 0xe4
    'NtGdiIcmBrushInfo', # 0xe5
    'NtGdiInit', # 0xe6
    'NtGdiInitSpool', # 0xe7
    'NtGdiIntersectClipRect', # 0xe8
    'NtGdiInvertRgn', # 0xe9
    'NtGdiLineTo', # 0xea
    'NtGdiMakeFontDir', # 0xeb
    'NtGdiMakeInfoDC', # 0xec
    'NtGdiMaskBlt', # 0xed
    'NtGdiModifyWorldTransform', # 0xee
    'NtGdiMonoBitmap', # 0xef
    'NtGdiMoveTo', # 0xf0
    'NtGdiOffsetClipRgn', # 0xf1
    'NtGdiOffsetRgn', # 0xf2
    'NtGdiOpenDCW', # 0xf3
    'NtGdiPatBlt', # 0xf4
    'NtGdiPolyPatBlt', # 0xf5
    'NtGdiPathToRegion', # 0xf6
    'NtGdiPlgBlt', # 0xf7
    'NtGdiPolyDraw', # 0xf8
    'NtGdiPolyPolyDraw', # 0xf9
    'NtGdiPolyTextOutW', # 0xfa
    'NtGdiPtInRegion', # 0xfb
    'NtGdiPtVisible', # 0xfc
    'NtGdiQueryFonts', # 0xfd
    'NtGdiQueryFontAssocInfo', # 0xfe
    'NtGdiRectangle', # 0xff
    'NtGdiRectInRegion', # 0x100
    'NtGdiRectVisible', # 0x101
    'NtGdiRemoveFontResourceW', # 0x102
    'NtGdiRemoveFontMemResourceEx', # 0x103
    'NtGdiResetDC', # 0x104
    'NtGdiResizePalette', # 0x105
    'NtGdiRestoreDC', # 0x106
    'NtGdiRoundRect', # 0x107
    'NtGdiSaveDC', # 0x108
    'NtGdiScaleViewportExtEx', # 0x109
    'NtGdiScaleWindowExtEx', # 0x10a
    'NtGdiSelectBitmap', # 0x10b
    'NtGdiSelectBrush', # 0x10c
    'NtGdiSelectClipPath', # 0x10d
    'NtGdiSelectFont', # 0x10e
    'NtGdiSelectPen', # 0x10f
    'NtGdiSetBitmapAttributes', # 0x110
    'NtGdiSetBitmapBits', # 0x111
    'NtGdiSetBitmapDimension', # 0x112
    'NtGdiSetBoundsRect', # 0x113
    'NtGdiSetBrushAttributes', # 0x114
    'NtGdiSetBrushOrg', # 0x115
    'NtGdiSetColorAdjustment', # 0x116
    'NtGdiSetColorSpace', # 0x117
    'NtGdiSetDeviceGammaRamp', # 0x118
    'NtGdiSetDIBitsToDeviceInternal', # 0x119
    'NtGdiSetFontEnumeration', # 0x11a
    'NtGdiSetFontXform', # 0x11b
    'NtGdiSetIcmMode', # 0x11c
    'NtGdiSetLinkedUFIs', # 0x11d
    'NtGdiSetMagicColors', # 0x11e
    'NtGdiSetMetaRgn', # 0x11f
    'NtGdiSetMiterLimit', # 0x120
    'NtGdiGetDeviceWidth', # 0x121
    'NtGdiMirrorWindowOrg', # 0x122
    'NtGdiSetLayout', # 0x123
    'NtGdiSetOPMSigningKeyAndSequenceNumbers', # 0x124
    'NtGdiSetPixel', # 0x125
    'NtGdiSetPixelFormat', # 0x126
    'NtGdiSetRectRgn', # 0x127
    'NtGdiSetSystemPaletteUse', # 0x128
    'NtGdiSetTextJustification', # 0x129
    'NtGdiSetVirtualResolution', # 0x12a
    'NtGdiSetSizeDevice', # 0x12b
    'NtGdiStartDoc', # 0x12c
    'NtGdiStartPage', # 0x12d
    'NtGdiStretchBlt', # 0x12e
    'NtGdiStretchDIBitsInternal', # 0x12f
    'NtGdiStrokeAndFillPath', # 0x130
    'NtGdiStrokePath', # 0x131
    'NtGdiSwapBuffers', # 0x132
    'NtGdiTransformPoints', # 0x133
    'NtGdiTransparentBlt', # 0x134
    'NtGdiUnloadPrinterDriver', # 0x135
    'NtGdiUnmapMemFont', # 0x136
    'NtGdiUnrealizeObject', # 0x137
    'NtGdiUpdateColors', # 0x138
    'NtGdiWidenPath', # 0x139
    'NtUserActivateKeyboardLayout', # 0x13a
    'NtUserAddClipboardFormatListener', # 0x13b
    'NtUserAlterWindowStyle', # 0x13c
    'NtUserAssociateInputContext', # 0x13d
    'NtUserAttachThreadInput', # 0x13e
    'NtUserBeginPaint', # 0x13f
    'NtUserBitBltSysBmp', # 0x140
    'NtUserBlockInput', # 0x141
    'NtUserBuildHimcList', # 0x142
    'NtUserBuildHwndList', # 0x143
    'NtUserBuildNameList', # 0x144
    'NtUserBuildPropList', # 0x145
    'NtUserCallHwnd', # 0x146
    'NtUserCallHwndLock', # 0x147
    'NtUserCallHwndOpt', # 0x148
    'NtUserCallHwndParam', # 0x149
    'NtUserCallHwndParamLock', # 0x14a
    'NtUserCallMsgFilter', # 0x14b
    'NtUserCallNextHookEx', # 0x14c
    'NtUserCallNoParam', # 0x14d
    'NtUserCallOneParam', # 0x14e
    'NtUserCallTwoParam', # 0x14f
    'NtUserChangeClipboardChain', # 0x150
    'NtUserChangeDisplaySettings', # 0x151
    'NtUserGetDisplayConfigBufferSizes', # 0x152
    'NtUserSetDisplayConfig', # 0x153
    'NtUserQueryDisplayConfig', # 0x154
    'NtUserDisplayConfigGetDeviceInfo', # 0x155
    'NtUserDisplayConfigSetDeviceInfo', # 0x156
    'NtUserCheckAccessForIntegrityLevel', # 0x157
    'NtUserCheckDesktopByThreadId', # 0x158
    'NtUserCheckWindowThreadDesktop', # 0x159
    'NtUserCheckMenuItem', # 0x15a
    'NtUserChildWindowFromPointEx', # 0x15b
    'NtUserClipCursor', # 0x15c
    'NtUserCloseClipboard', # 0x15d
    'NtUserCloseDesktop', # 0x15e
    'NtUserCloseWindowStation', # 0x15f
    'NtUserConsoleControl', # 0x160
    'NtUserConvertMemHandle', # 0x161
    'NtUserCopyAcceleratorTable', # 0x162
    'NtUserCountClipboardFormats', # 0x163
    'NtUserCreateAcceleratorTable', # 0x164
    'NtUserCreateCaret', # 0x165
    'NtUserCreateDesktopEx', # 0x166
    'NtUserCreateInputContext', # 0x167
    'NtUserCreateLocalMemHandle', # 0x168
    'NtUserCreateWindowEx', # 0x169
    'NtUserCreateWindowStation', # 0x16a
    'NtUserDdeInitialize', # 0x16b
    'NtUserDeferWindowPos', # 0x16c
    'NtUserDefSetText', # 0x16d
    'NtUserDeleteMenu', # 0x16e
    'NtUserDestroyAcceleratorTable', # 0x16f
    'NtUserDestroyCursor', # 0x170
    'NtUserDestroyInputContext', # 0x171
    'NtUserDestroyMenu', # 0x172
    'NtUserDestroyWindow', # 0x173
    'NtUserDisableThreadIme', # 0x174
    'NtUserDispatchMessage', # 0x175
    'NtUserDoSoundConnect', # 0x176
    'NtUserDoSoundDisconnect', # 0x177
    'NtUserDragDetect', # 0x178
    'NtUserDragObject', # 0x179
    'NtUserDrawAnimatedRects', # 0x17a
    'NtUserDrawCaption', # 0x17b
    'NtUserDrawCaptionTemp', # 0x17c
    'NtUserDrawIconEx', # 0x17d
    'NtUserDrawMenuBarTemp', # 0x17e
    'NtUserEmptyClipboard', # 0x17f
    'NtUserEnableMenuItem', # 0x180
    'NtUserEnableScrollBar', # 0x181
    'NtUserEndDeferWindowPosEx', # 0x182
    'NtUserEndMenu', # 0x183
    'NtUserEndPaint', # 0x184
    'NtUserEnumDisplayDevices', # 0x185
    'NtUserEnumDisplayMonitors', # 0x186
    'NtUserEnumDisplaySettings', # 0x187
    'NtUserEvent', # 0x188
    'NtUserExcludeUpdateRgn', # 0x189
    'NtUserFillWindow', # 0x18a
    'NtUserFindExistingCursorIcon', # 0x18b
    'NtUserFindWindowEx', # 0x18c
    'NtUserFlashWindowEx', # 0x18d
    'NtUserFrostCrashedWindow', # 0x18e
    'NtUserGetAltTabInfo', # 0x18f
    'NtUserGetAncestor', # 0x190
    'NtUserGetAppImeLevel', # 0x191
    'NtUserGetAsyncKeyState', # 0x192
    'NtUserGetAtomName', # 0x193
    'NtUserGetCaretBlinkTime', # 0x194
    'NtUserGetCaretPos', # 0x195
    'NtUserGetClassInfoEx', # 0x196
    'NtUserGetClassName', # 0x197
    'NtUserGetClipboardData', # 0x198
    'NtUserGetClipboardFormatName', # 0x199
    'NtUserGetClipboardOwner', # 0x19a
    'NtUserGetClipboardSequenceNumber', # 0x19b
    'NtUserGetClipboardViewer', # 0x19c
    'NtUserGetClipCursor', # 0x19d
    'NtUserGetComboBoxInfo', # 0x19e
    'NtUserGetControlBrush', # 0x19f
    'NtUserGetControlColor', # 0x1a0
    'NtUserGetCPD', # 0x1a1
    'NtUserGetCursorFrameInfo', # 0x1a2
    'NtUserGetCursorInfo', # 0x1a3
    'NtUserGetDC', # 0x1a4
    'NtUserGetDCEx', # 0x1a5
    'NtUserGetDoubleClickTime', # 0x1a6
    'NtUserGetForegroundWindow', # 0x1a7
    'NtUserGetGuiResources', # 0x1a8
    'NtUserGetGUIThreadInfo', # 0x1a9
    'NtUserGetIconInfo', # 0x1aa
    'NtUserGetIconSize', # 0x1ab
    'NtUserGetImeHotKey', # 0x1ac
    'NtUserGetImeInfoEx', # 0x1ad
    'NtUserGetInputLocaleInfo', # 0x1ae
    'NtUserGetInternalWindowPos', # 0x1af
    'NtUserGetKeyboardLayoutList', # 0x1b0
    'NtUserGetKeyboardLayoutName', # 0x1b1
    'NtUserGetKeyboardState', # 0x1b2
    'NtUserGetKeyNameText', # 0x1b3
    'NtUserGetKeyState', # 0x1b4
    'NtUserGetListBoxInfo', # 0x1b5
    'NtUserGetMenuBarInfo', # 0x1b6
    'NtUserGetMenuIndex', # 0x1b7
    'NtUserGetMenuItemRect', # 0x1b8
    'NtUserGetMessage', # 0x1b9
    'NtUserGetMouseMovePointsEx', # 0x1ba
    'NtUserGetObjectInformation', # 0x1bb
    'NtUserGetOpenClipboardWindow', # 0x1bc
    'NtUserGetPriorityClipboardFormat', # 0x1bd
    'NtUserGetProcessWindowStation', # 0x1be
    'NtUserGetRawInputBuffer', # 0x1bf
    'NtUserGetRawInputData', # 0x1c0
    'NtUserGetRawInputDeviceInfo', # 0x1c1
    'NtUserGetRawInputDeviceList', # 0x1c2
    'NtUserGetRegisteredRawInputDevices', # 0x1c3
    'NtUserGetScrollBarInfo', # 0x1c4
    'NtUserGetSystemMenu', # 0x1c5
    'NtUserGetThreadDesktop', # 0x1c6
    'NtUserGetThreadState', # 0x1c7
    'NtUserGetTitleBarInfo', # 0x1c8
    'NtUserGetTopLevelWindow', # 0x1c9
    'NtUserGetUpdatedClipboardFormats', # 0x1ca
    'NtUserGetUpdateRect', # 0x1cb
    'NtUserGetUpdateRgn', # 0x1cc
    'NtUserGetWindowCompositionInfo', # 0x1cd
    'NtUserGetWindowCompositionAttribute', # 0x1ce
    'NtUserGetWindowDC', # 0x1cf
    'NtUserGetWindowDisplayAffinity', # 0x1d0
    'NtUserGetWindowPlacement', # 0x1d1
    'NtUserGetWOWClass', # 0x1d2
    'NtUserGhostWindowFromHungWindow', # 0x1d3
    'NtUserHardErrorControl', # 0x1d4
    'NtUserHideCaret', # 0x1d5
    'NtUserHiliteMenuItem', # 0x1d6
    'NtUserHungWindowFromGhostWindow', # 0x1d7
    'NtUserImpersonateDdeClientWindow', # 0x1d8
    'NtUserInitialize', # 0x1d9
    'NtUserInitializeClientPfnArrays', # 0x1da
    'NtUserInitTask', # 0x1db
    'NtUserInternalGetWindowText', # 0x1dc
    'NtUserInternalGetWindowIcon', # 0x1dd
    'NtUserInvalidateRect', # 0x1de
    'NtUserInvalidateRgn', # 0x1df
    'NtUserIsClipboardFormatAvailable', # 0x1e0
    'NtUserIsTopLevelWindow', # 0x1e1
    'NtUserKillTimer', # 0x1e2
    'NtUserLoadKeyboardLayoutEx', # 0x1e3
    'NtUserLockWindowStation', # 0x1e4
    'NtUserLockWindowUpdate', # 0x1e5
    'NtUserLockWorkStation', # 0x1e6
    'NtUserLogicalToPhysicalPoint', # 0x1e7
    'NtUserMapVirtualKeyEx', # 0x1e8
    'NtUserMenuItemFromPoint', # 0x1e9
    'NtUserMessageCall', # 0x1ea
    'NtUserMinMaximize', # 0x1eb
    'NtUserMNDragLeave', # 0x1ec
    'NtUserMNDragOver', # 0x1ed
    'NtUserModifyUserStartupInfoFlags', # 0x1ee
    'NtUserMoveWindow', # 0x1ef
    'NtUserNotifyIMEStatus', # 0x1f0
    'NtUserNotifyProcessCreate', # 0x1f1
    'NtUserNotifyWinEvent', # 0x1f2
    'NtUserOpenClipboard', # 0x1f3
    'NtUserOpenDesktop', # 0x1f4
    'NtUserOpenInputDesktop', # 0x1f5
    'NtUserOpenThreadDesktop', # 0x1f6
    'NtUserOpenWindowStation', # 0x1f7
    'NtUserPaintDesktop', # 0x1f8
    'NtUserPaintMonitor', # 0x1f9
    'NtUserPeekMessage', # 0x1fa
    'NtUserPhysicalToLogicalPoint', # 0x1fb
    'NtUserPostMessage', # 0x1fc
    'NtUserPostThreadMessage', # 0x1fd
    'NtUserPrintWindow', # 0x1fe
    'NtUserProcessConnect', # 0x1ff
    'NtUserQueryInformationThread', # 0x200
    'NtUserQueryInputContext', # 0x201
    'NtUserQuerySendMessage', # 0x202
    'NtUserQueryWindow', # 0x203
    'NtUserRealChildWindowFromPoint', # 0x204
    'NtUserRealInternalGetMessage', # 0x205
    'NtUserRealWaitMessageEx', # 0x206
    'NtUserRedrawWindow', # 0x207
    'NtUserRegisterClassExWOW', # 0x208
    'NtUserRegisterErrorReportingDialog', # 0x209
    'NtUserRegisterUserApiHook', # 0x20a
    'NtUserRegisterHotKey', # 0x20b
    'NtUserRegisterRawInputDevices', # 0x20c
    'NtUserRegisterServicesProcess', # 0x20d
    'NtUserRegisterTasklist', # 0x20e
    'NtUserRegisterWindowMessage', # 0x20f
    'NtUserRemoveClipboardFormatListener', # 0x210
    'NtUserRemoveMenu', # 0x211
    'NtUserRemoveProp', # 0x212
    'NtUserResolveDesktopForWOW', # 0x213
    'NtUserSBGetParms', # 0x214
    'NtUserScrollDC', # 0x215
    'NtUserScrollWindowEx', # 0x216
    'NtUserSelectPalette', # 0x217
    'NtUserSendInput', # 0x218
    'NtUserSetActiveWindow', # 0x219
    'NtUserSetAppImeLevel', # 0x21a
    'NtUserSetCapture', # 0x21b
    'NtUserSetChildWindowNoActivate', # 0x21c
    'NtUserSetClassLong', # 0x21d
    'NtUserSetClassWord', # 0x21e
    'NtUserSetClipboardData', # 0x21f
    'NtUserSetClipboardViewer', # 0x220
    'NtUserSetCursor', # 0x221
    'NtUserSetCursorContents', # 0x222
    'NtUserSetCursorIconData', # 0x223
    'NtUserSetFocus', # 0x224
    'NtUserSetImeHotKey', # 0x225
    'NtUserSetImeInfoEx', # 0x226
    'NtUserSetImeOwnerWindow', # 0x227
    'NtUserSetInformationThread', # 0x228
    'NtUserSetInternalWindowPos', # 0x229
    'NtUserSetKeyboardState', # 0x22a
    'NtUserSetMenu', # 0x22b
    'NtUserSetMenuContextHelpId', # 0x22c
    'NtUserSetMenuDefaultItem', # 0x22d
    'NtUserSetMenuFlagRtoL', # 0x22e
    'NtUserSetObjectInformation', # 0x22f
    'NtUserSetParent', # 0x230
    'NtUserSetProcessWindowStation', # 0x231
    'NtUserGetProp', # 0x232
    'NtUserSetProp', # 0x233
    'NtUserSetScrollInfo', # 0x234
    'NtUserSetShellWindowEx', # 0x235
    'NtUserSetSysColors', # 0x236
    'NtUserSetSystemCursor', # 0x237
    'NtUserSetSystemMenu', # 0x238
    'NtUserSetSystemTimer', # 0x239
    'NtUserSetThreadDesktop', # 0x23a
    'NtUserSetThreadLayoutHandles', # 0x23b
    'NtUserSetThreadState', # 0x23c
    'NtUserSetTimer', # 0x23d
    'NtUserSetProcessDPIAware', # 0x23e
    'NtUserSetWindowCompositionAttribute', # 0x23f
    'NtUserSetWindowDisplayAffinity', # 0x240
    'NtUserSetWindowFNID', # 0x241
    'NtUserSetWindowLong', # 0x242
    'NtUserSetWindowPlacement', # 0x243
    'NtUserSetWindowPos', # 0x244
    'NtUserSetWindowRgn', # 0x245
    'NtUserGetWindowRgnEx', # 0x246
    'NtUserSetWindowRgnEx', # 0x247
    'NtUserSetWindowsHookAW', # 0x248
    'NtUserSetWindowsHookEx', # 0x249
    'NtUserSetWindowStationUser', # 0x24a
    'NtUserSetWindowWord', # 0x24b
    'NtUserSetWinEventHook', # 0x24c
    'NtUserShowCaret', # 0x24d
    'NtUserShowScrollBar', # 0x24e
    'NtUserShowWindow', # 0x24f
    'NtUserShowWindowAsync', # 0x250
    'NtUserSoundSentry', # 0x251
    'NtUserSwitchDesktop', # 0x252
    'NtUserSystemParametersInfo', # 0x253
    'NtUserTestForInteractiveUser', # 0x254
    'NtUserThunkedMenuInfo', # 0x255
    'NtUserThunkedMenuItemInfo', # 0x256
    'NtUserToUnicodeEx', # 0x257
    'NtUserTrackMouseEvent', # 0x258
    'NtUserTrackPopupMenuEx', # 0x259
    'NtUserCalculatePopupWindowPosition', # 0x25a
    'NtUserCalcMenuBar', # 0x25b
    'NtUserPaintMenuBar', # 0x25c
    'NtUserTranslateAccelerator', # 0x25d
    'NtUserTranslateMessage', # 0x25e
    'NtUserUnhookWindowsHookEx', # 0x25f
    'NtUserUnhookWinEvent', # 0x260
    'NtUserUnloadKeyboardLayout', # 0x261
    'NtUserUnlockWindowStation', # 0x262
    'NtUserUnregisterClass', # 0x263
    'NtUserUnregisterUserApiHook', # 0x264
    'NtUserUnregisterHotKey', # 0x265
    'NtUserUpdateInputContext', # 0x266
    'NtUserUpdateInstance', # 0x267
    'NtUserUpdateLayeredWindow', # 0x268
    'NtUserGetLayeredWindowAttributes', # 0x269
    'NtUserSetLayeredWindowAttributes', # 0x26a
    'NtUserUpdatePerUserSystemParameters', # 0x26b
    'NtUserUserHandleGrantAccess', # 0x26c
    'NtUserValidateHandleSecure', # 0x26d
    'NtUserValidateRect', # 0x26e
    'NtUserValidateTimerCallback', # 0x26f
    'NtUserVkKeyScanEx', # 0x270
    'NtUserWaitForInputIdle', # 0x271
    'NtUserWaitForMsgAndEvent', # 0x272
    'NtUserWaitMessage', # 0x273
    'NtUserWindowFromPhysicalPoint', # 0x274
    'NtUserWindowFromPoint', # 0x275
    'NtUserYieldTask', # 0x276
    'NtUserRemoteConnect', # 0x277
    'NtUserRemoteRedrawRectangle', # 0x278
    'NtUserRemoteRedrawScreen', # 0x279
    'NtUserRemoteStopScreenUpdates', # 0x27a
    'NtUserCtxDisplayIOCtl', # 0x27b
    'NtUserRegisterSessionPort', # 0x27c
    'NtUserUnregisterSessionPort', # 0x27d
    'NtUserUpdateWindowTransform', # 0x27e
    'NtUserDwmStartRedirection', # 0x27f
    'NtUserDwmStopRedirection', # 0x280
    'NtUserGetWindowMinimizeRect', # 0x281
    'NtUserSfmDxBindSwapChain', # 0x282
    'NtUserSfmDxOpenSwapChain', # 0x283
    'NtUserSfmDxReleaseSwapChain', # 0x284
    'NtUserSfmDxSetSwapChainBindingStatus', # 0x285
    'NtUserSfmDxQuerySwapChainBindingStatus', # 0x286
    'NtUserSfmDxReportPendingBindingsToDwm', # 0x287
    'NtUserSfmDxGetSwapChainStats', # 0x288
    'NtUserSfmDxSetSwapChainStats', # 0x289
    'NtUserSfmGetLogicalSurfaceBinding', # 0x28a
    'NtUserSfmDestroyLogicalSurfaceBinding', # 0x28b
    'NtUserModifyWindowTouchCapability', # 0x28c
    'NtUserIsTouchWindow', # 0x28d
    'NtUserSendTouchInput', # 0x28e
    'NtUserEndTouchOperation', # 0x28f
    'NtUserGetTouchInputInfo', # 0x290
    'NtUserChangeWindowMessageFilterEx', # 0x291
    'NtUserInjectGesture', # 0x292
    'NtUserGetGestureInfo', # 0x293
    'NtUserGetGestureExtArgs', # 0x294
    'NtUserManageGestureHandlerWindow', # 0x295
    'NtUserSetGestureConfig', # 0x296
    'NtUserGetGestureConfig', # 0x297
    'NtGdiEngAssociateSurface', # 0x298
    'NtGdiEngCreateBitmap', # 0x299
    'NtGdiEngCreateDeviceSurface', # 0x29a
    'NtGdiEngCreateDeviceBitmap', # 0x29b
    'NtGdiEngCreatePalette', # 0x29c
    'NtGdiEngComputeGlyphSet', # 0x29d
    'NtGdiEngCopyBits', # 0x29e
    'NtGdiEngDeletePalette', # 0x29f
    'NtGdiEngDeleteSurface', # 0x2a0
    'NtGdiEngEraseSurface', # 0x2a1
    'NtGdiEngUnlockSurface', # 0x2a2
    'NtGdiEngLockSurface', # 0x2a3
    'NtGdiEngBitBlt', # 0x2a4
    'NtGdiEngStretchBlt', # 0x2a5
    'NtGdiEngPlgBlt', # 0x2a6
    'NtGdiEngMarkBandingSurface', # 0x2a7
    'NtGdiEngStrokePath', # 0x2a8
    'NtGdiEngFillPath', # 0x2a9
    'NtGdiEngStrokeAndFillPath', # 0x2aa
    'NtGdiEngPaint', # 0x2ab
    'NtGdiEngLineTo', # 0x2ac
    'NtGdiEngAlphaBlend', # 0x2ad
    'NtGdiEngGradientFill', # 0x2ae
    'NtGdiEngTransparentBlt', # 0x2af
    'NtGdiEngTextOut', # 0x2b0
    'NtGdiEngStretchBltROP', # 0x2b1
    'NtGdiXLATEOBJ_cGetPalette', # 0x2b2
    'NtGdiXLATEOBJ_iXlate', # 0x2b3
    'NtGdiXLATEOBJ_hGetColorTransform', # 0x2b4
    'NtGdiCLIPOBJ_bEnum', # 0x2b5
    'NtGdiCLIPOBJ_cEnumStart', # 0x2b6
    'NtGdiCLIPOBJ_ppoGetPath', # 0x2b7
    'NtGdiEngDeletePath', # 0x2b8
    'NtGdiEngCreateClip', # 0x2b9
    'NtGdiEngDeleteClip', # 0x2ba
    'NtGdiBRUSHOBJ_ulGetBrushColor', # 0x2bb
    'NtGdiBRUSHOBJ_pvAllocRbrush', # 0x2bc
    'NtGdiBRUSHOBJ_pvGetRbrush', # 0x2bd
    'NtGdiBRUSHOBJ_hGetColorTransform', # 0x2be
    'NtGdiXFORMOBJ_bApplyXform', # 0x2bf
    'NtGdiXFORMOBJ_iGetXform', # 0x2c0
    'NtGdiFONTOBJ_vGetInfo', # 0x2c1
    'NtGdiFONTOBJ_pxoGetXform', # 0x2c2
    'NtGdiFONTOBJ_cGetGlyphs', # 0x2c3
    'NtGdiFONTOBJ_pifi', # 0x2c4
    'NtGdiFONTOBJ_pfdg', # 0x2c5
    'NtGdiFONTOBJ_pQueryGlyphAttrs', # 0x2c6
    'NtGdiFONTOBJ_pvTrueTypeFontFile', # 0x2c7
    'NtGdiFONTOBJ_cGetAllGlyphHandles', # 0x2c8
    'NtGdiSTROBJ_bEnum', # 0x2c9
    'NtGdiSTROBJ_bEnumPositionsOnly', # 0x2ca
    'NtGdiSTROBJ_bGetAdvanceWidths', # 0x2cb
    'NtGdiSTROBJ_vEnumStart', # 0x2cc
    'NtGdiSTROBJ_dwGetCodePage', # 0x2cd
    'NtGdiPATHOBJ_vGetBounds', # 0x2ce
    'NtGdiPATHOBJ_bEnum', # 0x2cf
    'NtGdiPATHOBJ_vEnumStart', # 0x2d0
    'NtGdiPATHOBJ_vEnumStartClipLines', # 0x2d1
    'NtGdiPATHOBJ_bEnumClipLines', # 0x2d2
    'NtGdiGetDhpdev', # 0x2d3
    'NtGdiEngCheckAbort', # 0x2d4
    'NtGdiHT_Get8BPPFormatPalette', # 0x2d5
    'NtGdiHT_Get8BPPMaskPalette', # 0x2d6
    'NtGdiUpdateTransform', # 0x2d7
    'NtGdiSetPUMPDOBJ', # 0x2d8
    'NtGdiBRUSHOBJ_DeleteRbrush', # 0x2d9
    'NtGdiUMPDEngFreeUserMem', # 0x2da
    'NtGdiDrawStream', # 0x2db
    'NtGdiSfmGetNotificationTokens', # 0x2dc
    'NtGdiHLSurfGetInformation', # 0x2dd
    'NtGdiHLSurfSetInformation', # 0x2de
    'NtGdiDdDDICreateAllocation', # 0x2df
    'NtGdiDdDDIQueryResourceInfo', # 0x2e0
    'NtGdiDdDDIOpenResource', # 0x2e1
    'NtGdiDdDDIDestroyAllocation', # 0x2e2
    'NtGdiDdDDISetAllocationPriority', # 0x2e3
    'NtGdiDdDDIQueryAllocationResidency', # 0x2e4
    'NtGdiDdDDICreateDevice', # 0x2e5
    'NtGdiDdDDIDestroyDevice', # 0x2e6
    'NtGdiDdDDICreateContext', # 0x2e7
    'NtGdiDdDDIDestroyContext', # 0x2e8
    'NtGdiDdDDICreateSynchronizationObject', # 0x2e9
    'NtGdiDdDDIOpenSynchronizationObject', # 0x2ea
    'NtGdiDdDDIDestroySynchronizationObject', # 0x2eb
    'NtGdiDdDDIWaitForSynchronizationObject', # 0x2ec
    'NtGdiDdDDISignalSynchronizationObject', # 0x2ed
    'NtGdiDdDDIGetRuntimeData', # 0x2ee
    'NtGdiDdDDIQueryAdapterInfo', # 0x2ef
    'NtGdiDdDDILock', # 0x2f0
    'NtGdiDdDDIUnlock', # 0x2f1
    'NtGdiDdDDIGetDisplayModeList', # 0x2f2
    'NtGdiDdDDISetDisplayMode', # 0x2f3
    'NtGdiDdDDIGetMultisampleMethodList', # 0x2f4
    'NtGdiDdDDIPresent', # 0x2f5
    'NtGdiDdDDIRender', # 0x2f6
    'NtGdiDdDDIOpenAdapterFromDeviceName', # 0x2f7
    'NtGdiDdDDIOpenAdapterFromHdc', # 0x2f8
    'NtGdiDdDDICloseAdapter', # 0x2f9
    'NtGdiDdDDIGetSharedPrimaryHandle', # 0x2fa
    'NtGdiDdDDIEscape', # 0x2fb
    'NtGdiDdDDIQueryStatistics', # 0x2fc
    'NtGdiDdDDISetVidPnSourceOwner', # 0x2fd
    'NtGdiDdDDIGetPresentHistory', # 0x2fe
    'NtGdiDdDDIGetPresentQueueEvent', # 0x2ff
    'NtGdiDdDDICreateOverlay', # 0x300
    'NtGdiDdDDIUpdateOverlay', # 0x301
    'NtGdiDdDDIFlipOverlay', # 0x302
    'NtGdiDdDDIDestroyOverlay', # 0x303
    'NtGdiDdDDIWaitForVerticalBlankEvent', # 0x304
    'NtGdiDdDDISetGammaRamp', # 0x305
    'NtGdiDdDDIGetDeviceState', # 0x306
    'NtGdiDdDDICreateDCFromMemory', # 0x307
    'NtGdiDdDDIDestroyDCFromMemory', # 0x308
    'NtGdiDdDDISetContextSchedulingPriority', # 0x309
    'NtGdiDdDDIGetContextSchedulingPriority', # 0x30a
    'NtGdiDdDDISetProcessSchedulingPriorityClass', # 0x30b
    'NtGdiDdDDIGetProcessSchedulingPriorityClass', # 0x30c
    'NtGdiDdDDIReleaseProcessVidPnSourceOwners', # 0x30d
    'NtGdiDdDDIGetScanLine', # 0x30e
    'NtGdiDdDDISetQueuedLimit', # 0x30f
    'NtGdiDdDDIPollDisplayChildren', # 0x310
    'NtGdiDdDDIInvalidateActiveVidPn', # 0x311
    'NtGdiDdDDICheckOcclusion', # 0x312
    'NtGdiDdDDIWaitForIdle', # 0x313
    'NtGdiDdDDICheckMonitorPowerState', # 0x314
    'NtGdiDdDDICheckExclusiveOwnership', # 0x315
    'NtGdiDdDDISetDisplayPrivateDriverFormat', # 0x316
    'NtGdiDdDDISharedPrimaryLockNotification', # 0x317
    'NtGdiDdDDISharedPrimaryUnLockNotification', # 0x318
    'NtGdiDdDDICreateKeyedMutex', # 0x319
    'NtGdiDdDDIOpenKeyedMutex', # 0x31a
    'NtGdiDdDDIDestroyKeyedMutex', # 0x31b
    'NtGdiDdDDIAcquireKeyedMutex', # 0x31c
    'NtGdiDdDDIReleaseKeyedMutex', # 0x31d
    'NtGdiDdDDIConfigureSharedResource', # 0x31e
    'NtGdiDdDDIGetOverlayState', # 0x31f
    'NtGdiDdDDICheckVidPnExclusiveOwnership', # 0x320
    'NtGdiDdDDICheckSharedResourceAccess', # 0x321
    'DxgStubEnableDirectDrawRedirection', # 0x322
    'DxgStubDeleteDirectDrawObject', # 0x323
    'NtGdiGetNumberOfPhysicalMonitors', # 0x324
    'NtGdiGetPhysicalMonitors', # 0x325
    'NtGdiGetPhysicalMonitorDescription', # 0x326
    'NtGdiDestroyPhysicalMonitor', # 0x327
    'NtGdiDDCCIGetVCPFeature', # 0x328
    'NtGdiDDCCISetVCPFeature', # 0x329
    'NtGdiDDCCISaveCurrentSettings', # 0x32a
    'NtGdiDDCCIGetCapabilitiesStringLength', # 0x32b
    'NtGdiDDCCIGetCapabilitiesString', # 0x32c
    'NtGdiDDCCIGetTimingReport', # 0x32d
    'NtGdiDdCreateFullscreenSprite', # 0x32e
    'NtGdiDdNotifyFullscreenSpriteUpdate', # 0x32f
    'NtGdiDdDestroyFullscreenSprite', # 0x330
    'NtGdiDdQueryVisRgnUniqueness', # 0x331
    'NtUserSetMirrorRendering', # 0x332
    'NtUserShowSystemCursor', # 0x333
    'NtUserMagControl', # 0x334
    'NtUserMagSetContextInformation', # 0x335
    'NtUserMagGetContextInformation', # 0x336
    'NtUserHwndQueryRedirectionInfo', # 0x337
    'NtUserHwndSetRedirectionInfo', # 0x338
    ],
]
