/*
$Id: BasicStringInfixOperatorLayout.java,v 1.3 2003/02/18 11:48:46 sander Exp $
*/


/*
Copyright (C) 2001-2002 Mainline Project (I3S - ESSI - CNRS -UNSA)

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

For further information on the GNU Lesser General Public License,
see: http://www.gnu.org/copyleft/lesser.html
For further information on this library, contact: mainline@essi.fr
*/


package fr.ove.openmath.jome.ctrlview.bidim;

import java.awt.*;
import java.util.*;
import fr.ove.openmath.jome.ctrlview.bidim.*;
import fr.ove.openmath.jome.ctrlview.bidim.selection.events.*;
import fr.ove.openmath.jome.model.*;

/**
* A layout manager for an infix operator which symbol can be rendered as a string (e.g. +, *)
*
* @author  1999 DIRAT Laurent
* @version 2.0  14/12/1999
*/
public class BasicStringInfixOperatorLayout extends StringInfixOperatorLayout {    
    /**
    * Inserts, if necessary, a display of the operator symbol that the display
    * laid by the instance represents.
    */
    protected void insertOperatorDisplay() {
        Display current, next, displayOperator;
        FormulaTreeStructure fatherFts = (FormulaTreeStructure) displayToLay.getListener();
        FormulaTreeStructure fts;
        int nbComponent = displayToLay.getComponentCount();
        
        // On parcourre tous les components prsents dans le display.
        for (int i = 1; i < nbComponent; i++) {
            // la rfrence sur le component courant
            current = (Display) displayToLay.getComponent(i - 1);
            // la rfrence sur le suivant
            next = (Display) displayToLay.getComponent(i);
            
            // Si le courant est un display d'oprateur alors on continue
            if (current.isSymbolOperatorDisplay())
                continue;
                
            // Si le suivant n'est pas un display d'oprateur alors 2 cas
            if (!next.isSymbolOperatorDisplay()) {
                // La seule distinction qu'il faut faire  ce stade l, c'est le cas o next
                // est le diplay d'un - unaire. Si c'est le cas, on n'insre pas de display.
                fts = (FormulaTreeStructure) next.getListener();
                if (fts.isOperator()) {
                    String ope = ((Operator) fts).getTheOperator();
                    if (ope.equals("-"))
                        continue;
                }
                    
                // On ajoute un display d'oprateur.
                displayOperator = createOperatorDisplay();
                displayToLay.add(displayOperator, displayOperator, i);
                
                // On met un listener  l'oprateur.
                // En fait, il n'y en a pas besoin, dans le sens o il n'y a pas spcifiquement de fts qui
                // coute le comportement de ce display. Nanmoins, il s'avre ncessaire qu'il en ait
                // un, par exemple lors de l'iconification, car c'est le display qui reoit la demande
                // d'iconification qui envoie l'vnement correspondant  la FTS. Or si ce display n'a pas
                // d'couteur, alors pb. Par cohrence, l'couteur du display d'oprateur, est le fts qui
                // reprsente cette opration. Par contre, la fts en question, n'coute pas le display
                // d'oprateur.
                displayOperator.addControlListener(fatherFts);
                i++;
                nbComponent++;
            }
        }
        
        // Mise  jour des rangs des displays
        displayToLay.adjustRank();
        // Mise  jour du nombre de components prsents dans le display.
        prevNbComponent = displayToLay.getComponentCount();
        // On n'a plus besoin d'insrer des displays d'oprateur.
        insertOperatorDisplay = false;
        // On fait en sorte que la mise  niveau des displays (oprateurs) soit faite.
        displayToLay.setUpdateLevel(true);
        // On a rajout un display, on demande le recalcul de tous les anctres
        // de l'instance.
        displayToLay.computeAncestorsAttributes();
    }
    
    /**
    * Checks the validity of the selection.
    */
    public void validateSelection() {
        Display childDisplay;
        DisplayLayout childLayout;
        SelectionEvent selEvt = new SelectionEvent(displayToLay);
        
        int nbChild = displayToLay.getComponentCount();
        
        // On parcourre la liste des displays, et on regarde sur chacun des dispays s'il faut slectionner
        // un de ses voisins.
        for (int i = 0; i < nbChild; i++) {
            childDisplay = (Display) displayToLay.getComponent(i);
            childLayout = (DisplayLayout) childDisplay.getLayout();
            
            // On regarde ici s'il faut slectionner le display  gauche de childLayout
            // Si ledit display n'est pas slectionner, on le slectionne.
            if (childLayout.selectLeftDisplay() && (i > 0)) {
                childDisplay = (Display) displayToLay.getComponent(i-1);
                if (!childDisplay.isSelected())
                    childDisplay.select();
            }

            // On regarde ici s'il faut slectionner le display  droite de childLayout
            // Si ledit display n'est pas slectionner, on le slectionne.
            if (childLayout.selectRightDisplay() && (i < (nbChild - 1))) {
                childDisplay = (Display) displayToLay.getComponent(i+1);
                if (!childDisplay.isSelected())
                    childDisplay.select();
                // On a slectionn le display  la position i+1, donc on incrmente ici i,
                // pour que dans le for, le i soit encore incrment et que l'on se positionne
                // ainsi sur un display suivant, non slectionn
                i++;
            }
        }
        
        // On parcourre la liste des displays et on regarde si les displays  gauche et  droite du display
        // courant ont des lments slectionns. Si c'est le cas et que le display courant est un display
        // d'oprateur et qu'il n'est pas slectionn, alors on slectionne le display  gauche, le displa
        // d'oprateur et le display  droite.
        // Ex: (...) + (...), dans chacune des parenthses, un lment est slectionn, on slectionne tout
        Display prev;
        Display next;
        for (int i = 1; i < (nbChild - 1); i++) {
            prev = (Display) displayToLay.getComponent(i-1);
            childDisplay = (Display) displayToLay.getComponent(i);
            next = (Display) displayToLay.getComponent(i+1);
            if (prev.gotSelectedElements() && next.gotSelectedElements()) {
                //if ((childDisplay instanceof StringDisplay) && !childDisplay.isSelected()) {
                if (childDisplay.isSymbolOperatorDisplay() && !childDisplay.isSelected()) {
                    if (!prev.isSelected())
                        prev.select();
                    childDisplay.select();
                    if (!next.isSelected())
                        next.select();
                }
            }
        }
        
        // On cr maintenant une liste contenant tous les displays qui ont t slectionns au cours des
        // oprations prcdentes.
        Vector list = new Vector();
        for (int i = 0; i < nbChild; i++) {
            childDisplay = (Display) displayToLay.getComponent(i);
            if (childDisplay.gotSelectedElements())
                list.addElement(childDisplay);
        }

        if (list.size() > 0) {
            if ((list.size() == nbChild) && !(displayToLay.getListener() instanceof Formula) && !(displayToLay.getListener() instanceof Slot)) {
                selEvt.setAction(SelectionEvent.PURGE, null);
                displayToLay.fireSelectionEvent(selEvt);

                displayToLay.setSelected();
                selEvt.setAction(SelectionEvent.ADD, displayToLay);
                displayToLay.fireSelectionEvent(selEvt);
            }
            else if (list.size() != 1) {
                selEvt.setAction(SelectionEvent.PURGE, null);
                displayToLay.fireSelectionEvent(selEvt);

                for (Enumeration e = list.elements(); e.hasMoreElements(); ) {
                    childDisplay = (Display) e.nextElement();
                    if (!childDisplay.isSelected())
                        childDisplay.select();
                    selEvt.setAction(SelectionEvent.ADD, childDisplay);
                    displayToLay.fireSelectionEvent(selEvt);
                }
            }
        }
        
        // On a une slection valide dans le display layed.
        // On demande la validation au niveau de son pre.
        // En principe,  cause du test sur le fait d'avoir une Formula, pas besoin
        // d'avoir le test juste suivant. A surveiller.
        Display display = displayToLay;
        if (display.getParent() instanceof Display) {
            display = (Display) display.getParent();
            //if (!(display.getListener() instanceof Formula))
            FormulaTreeStructure fts = (FormulaTreeStructure) display.getListener();
            if (fts.getFather() != null)
                ((DisplayLayout) display.getLayout()).validateSelection();
        }
        
        display.repaint(); // faut voir, parce que autant de repaint que de display ?????????
    }


    /**
    * Checks the validity of the deselection.
    * @param display the display to deselect.
    */
    public void validateDeselection(Display display) {
        Display father = displayToLay;
        Display tmp;
        SelectionEvent selEvt = new SelectionEvent(father);
        int rank = display.getRank();

        // Premier cas: father (i.e. le display gr par l'instance) est slectionn.
        if (father.isSelected()) {
            // On l'enlve de la liste des displays slectionns.
            father.setNotSelected();
            selEvt.setAction(SelectionEvent.REMOVE, father);
            father.fireSelectionEvent(selEvt);

            // Comme on arrive dans cette mthode par display, display a t dj dslectionn.
            // De plus, ce LM gre principalement (voire que) des displays N-aires dont il s'agit
            // la plupart du temps d'une succession de displays oprandes entre lesquels se trouvent
            // des displays oprateur (ex: + ou *).
            // Donc, s'ils existent, on doit alors dslectionner le display prcdent et le display
            // suivant... display. (d'o rcupration du rang de display au dbut)

            // On s'occupe du display prcdant... display.
            if (rank > 0) {
                if (!(display.getListener() instanceof UnaryMinus)) {
                    // Il existe un display avant... display, donc on prend garde de le dslectionner,
                    // s'il tait slectionn.
                    tmp = ((Display) father.getComponent(rank-1));
                    if (tmp.isSelected()) {
                        // On dslectionne donc ledit display.
                        tmp.deselect();

                        // Maintenant, on regarde s'il existe un display prcdent celui que l'on vient
                        // de dslectionner, qui est un display d'oprateur et qui est slectionn.
                        // Si c'est le cas, on le dslectionne.
                        if (rank > 1) {
                            tmp = ((Display) father.getComponent(rank-2));
                            if (tmp.isSymbolOperatorDisplay() && tmp.isSelected())
                                tmp.deselect();
                        }
                    }
                }
            }

            // On s'occupe du display suivant... display.
            if (rank < (father.getComponentCount()-1)) {
                // Il existe un display aprs... display, donc on prend garde de le dslectionner,
                // s'il tait slectionn.
                tmp = ((Display) father.getComponent(rank+1));
                // Il faut faire attention dans le cas d'une addition o il y aurait un oprateur unaire.
                // (Normalement seulement un UnaryMinus). Dans le cas le plus simple, une soustraction: a-b
                // Si a-b est slectionn et que l'on arrive ici parce on a dslectionn a, alors -b doit rester
                // slectionn. D'o ce cas particulier supplmentaire.
                if (!(tmp.getListener() instanceof UnaryMinus)) {
                    if (tmp.isSelected()) {
                        tmp.deselect();

                        // Maintenant, on regarde s'il existe un display suivant celui que l'on vient
                        // de dslectionner, qui est un display d'oprateur et qui est slectionn.
                        // Si c'est le cas, on le dslectionne.
                        if (rank < (father.getComponentCount()-2)) {
                            tmp = ((Display) father.getComponent(rank+2));
                            if (tmp.isSymbolOperatorDisplay() && tmp.isSelected())
                                tmp.deselect();
                        }
                    }
                }
                else
                    ((LeftAssocPrefixedUnaryOperatorLayout) tmp.getLayout()).setSelectLeftDisplay(false);
            }
            
            // On parcourre la liste des display de father et on ajoute dans la liste des slectionns,
            // ... les slectionns.
            for (int i = 0; i < father.getComponentCount(); i++) {
                tmp = (Display) father.getComponent(i);
                if (tmp.isSelected()) {
                    selEvt.setAction(SelectionEvent.ADD, tmp);
                    father.fireSelectionEvent(selEvt);
                }
            }
            
            // On regarde maintenant au niveau suprieur, si la dslection de father gnre
            // une dslection qui est valide.
            if (father.getParent() instanceof Display) {
                father = (Display) father.getParent();
                FormulaTreeStructure fts = (FormulaTreeStructure) father.getListener();
                if (fts.getFather() != null)
                    ((DisplayLayout) father.getLayout()).validateDeselection(displayToLay);
            }
        }
        // Deuxime cas: father (i.e. le display gr par l'instance) n'est pas slectionn.
        // Mais, il en a des slectionns, puisque display fait partie de sa descendance.
        else {
            // Et bien, on fait exactement la mme chose que prcdemment,  la diffrence importante
            // que l, les displays slectionns font partie de la liste des displays slectionns.
            // Il faut donc les y enlever.
            if (rank > 0) {
                if (!(display.getListener() instanceof UnaryMinus)) {
                    tmp = ((Display) father.getComponent(rank-1));
                    if (tmp.isSelected()) {
                        tmp.deselect();
                        selEvt.setAction(SelectionEvent.REMOVE, tmp);
                        father.fireSelectionEvent(selEvt);

                        if (rank > 1) {
                            tmp = ((Display) father.getComponent(rank-2));
                            if (tmp.isSymbolOperatorDisplay() && tmp.isSelected()) {
                                tmp.deselect();
                                selEvt.setAction(SelectionEvent.REMOVE, tmp);
                                father.fireSelectionEvent(selEvt);
                            }
                        }
                    }
                }
            }

            if (rank < (father.getComponentCount()-1)) {
                tmp = ((Display) father.getComponent(rank+1));
                // Il faut faire attention dans le cas d'une addition o il y aurait un oprateur unaire.
                // (Normalement seulement un UnaryMinus). Dans le cas le plus simple, une soustraction: a-b
                // Si a-b est slectionn et que l'on arrive ici parce on a dslectionn a, alors -b doit rester
                // slectionn. D'o ce cas particulier supplmentaire.
                if (!(tmp.getListener() instanceof UnaryMinus)) {
                    if (tmp.isSelected()) {
                        tmp.deselect();

                        // Maintenant, on regarde s'il existe un display suivant celui que l'on vient
                        // de dslectionner, qui est un display d'oprateur et qui est slectionn.
                        // Si c'est le cas, on le dslectionne.
                        if (rank < (father.getComponentCount()-2)) {
                            tmp = ((Display) father.getComponent(rank+2));
                            if (tmp.isSymbolOperatorDisplay() && tmp.isSelected())
                                tmp.deselect();
                        }
                    }
                }
                else
                    ((LeftAssocPrefixedUnaryOperatorLayout) tmp.getLayout()).setSelectLeftDisplay(false);
            }
        }

        // Comme toujours, on contrle maintenant, avec les ventuels displays slectionns restant,
        // si la slection est valide.
        validateSelection();
        // On met  jour le display.
        father.repaint();
    }
}