/*
$Id: ScriptLayout.java,v 1.3 2003/02/18 11:48:47 sander Exp $
*/


/*
Copyright (C) 2001-2002 Mainline Project (I3S - ESSI - CNRS -UNSA)

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

For further information on the GNU Lesser General Public License,
see: http://www.gnu.org/copyleft/lesser.html
For further information on this library, contact: mainline@essi.fr
*/


package fr.ove.openmath.jome.ctrlview.bidim;

import java.awt.*;
import fr.ove.openmath.jome.ctrlview.bidim.Display;
import fr.ove.openmath.jome.ctrlview.bidim.DisplayLayout;
import fr.ove.openmath.jome.ctrlview.bidim.HorizontalLayout;
import fr.ove.openmath.jome.ctrlview.bidim.selection.events.SelectionEvent;
import fr.ove.openmath.jome.model.*;

/**
* A layout manager that lays components horyzontally, but the last one in the
* list, is treated as a superscript or an underscript in the inherited classes.
* (There is a shift calculated)
*
* @author  1999 DIRAT Laurent
* @version 2.0 19/07/1999
*/
public abstract class ScriptLayout extends HorizontalLayout {
    /**
    * Updates the level of the display that is layed out.<BR>
    * @param level the level put to the display
    */
    public void updateLevel(int level) {
        Display tmp;
        
        // Pour viter de refaire le calcul plusieurs fois....
        if (displayToLay.getUpdateLevel()) {
            // On met le niveau adquat
            displayToLay.setLevel(level);
            // On scale le display en fonction du niveau
            displayToLay.scaleDisplay();
            // On n'a plus besoin de mettre  jour le niveau de l'instance
            displayToLay.setUpdateLevel(false);
            
            // Le premier display fils possde le mme niveau que son pre.
            tmp = (Display) displayToLay.getComponent(0);
            ((DisplayLayout) tmp.getLayout()).updateLevel(level);
            
            // Le deuxime display fils possde le mme niveau que la base + 1.
            // (on applique une rduction de taille)
            tmp = (Display) displayToLay.getComponent(1);
            ((DisplayLayout) tmp.getLayout()).updateLevel(level+1);
        }
    }
    
    /**
    * Checks the validity of the selection.
    */
    public void validateSelection() {
        SelectionEvent selEvt = new SelectionEvent(displayToLay);

        // La validit de la slection est triviale.
        // Si un des lments de la puissance est slectionn, alors la slection
        // de l'autre lment entrane la slection de toute la puissance.
        Display base = (Display) displayToLay.getComponent(0);
        Display script = (Display) displayToLay.getComponent(1);
        if (base.gotSelectedElements() && script.gotSelectedElements()) {
            displayToLay.select();
            // On purge la liste des lments slectionns.
            selEvt.setAction(SelectionEvent.PURGE, null);
            displayToLay.fireSelectionEvent(selEvt);
            // On y ajoute notre puissance.
            selEvt.setAction(SelectionEvent.ADD, displayToLay);
            displayToLay.fireSelectionEvent(selEvt);
        }
        
        // On a vrifi la validit de la slection de la puissance. On doit maitenant
        // la contrler au niveau suprieur, au niveau du pre.
        // Ex : on a l'expression A+B^C et on a A dj slectionn. On slectionne C.
        // D'un pt de vue smantique (oui, on va dire a comme a) A et C ne peuvent
        // tre slectionns sparment. Tout doit tre slectionn. Et a, c'est la 
        // validation de la slection qui va le dterminer. oufff....
        Display display = displayToLay;
        if (displayToLay.getParent() instanceof Display) {
            display = (Display) displayToLay.getParent();
            FormulaTreeStructure fts = (FormulaTreeStructure) display.getListener();
            if (fts.getFather() != null) // Si fts n'est pas la racine de la formule, on valide la slection
                ((DisplayLayout) display.getLayout()).validateSelection();
        }

        // On met  jour l'affichage.
        display.repaint();
    }
    
    /**
    * Checks the validity of the deselection.
    * @param display the display to deselect.
    */
    public void validateDeselection(Display display) {
        Display tmp;
        SelectionEvent selEvt = new SelectionEvent(displayToLay);
        
        if (displayToLay.isSelected()) {
            // On dslectionne la puissance
            displayToLay.setNotSelected();
            // On enlve le display pre de la liste des display slectionns.
            selEvt.setAction(SelectionEvent.REMOVE, displayToLay);
            displayToLay.fireSelectionEvent(selEvt);
            
            // Si la puissance toute entire tait slectionne, donc prsente dans la liste
            // des lments slectionn. Ce n'est pas le cas de la base et de l'exposant.
            // Donc en fonction de cela, il faut y ajouter l'lment adquat
            if (((Display) displayToLay.getComponent(0)).isSelected())
                // On a demand la dslection en cliquant sur l'exposant, ce qui revient
                //  slectionner uniquement la base.
                // On l'ajoute donc dans la liste des display slectionns.
                selEvt.setAction(SelectionEvent.ADD, (Display) displayToLay.getComponent(0));
            else
                // On a demand la dslection en cliquant sur la base, ce qui revient
                //  slectionner uniquement l'exposant.
                // On l'ajoute donc dans la liste des display slectionns.
                selEvt.setAction(SelectionEvent.ADD, (Display) displayToLay.getComponent(1));

            displayToLay.fireSelectionEvent(selEvt);

            // Comme pour la slection, on contrle la validit de la dslection.
            Display father = displayToLay;
            if (displayToLay.getParent() instanceof Display) {
                father = (Display) displayToLay.getParent();
                FormulaTreeStructure fts = (FormulaTreeStructure) father.getListener();
                if (fts.getFather() != null)
                    ((DisplayLayout) father.getLayout()).validateDeselection(displayToLay);
            }
            // H oui, on contrle la validit de la slection... dans une dslection.
            // Toujours le mme pb, est-ce que le nouvel tat de la slection (aprs
            // dslection donc) est syntaxiquement cohrent ?
            validateSelection();
            
            // On met  jour l'affichage.
            father.repaint();
        }        
    }
    
    /**
    * The display needs to be rebuilt. We do this.
    */
    public void rebuildDisplay() {
        Display tmp;
        Display base = null;
        Display script = null;
        // On parcourre la liste des displays pour trouver qui est qui.
        for (int i = 0; i < 2; i++) {
            tmp = (Display) displayToLay.getComponent(i);
            // On fait les initialisations qui s'imposent pour le bon repositionnement de chacun.
            tmp.setLocation(0,0);
            if (((FormulaTreeStructure) tmp.getListener()).getRank() == 0)
                base = tmp;
            else 
                script = tmp;
        }
        // On a retrouv qui est qui, on reconstruit le display pour tout mettre
        //  la bonne position.
        displayToLay.removeAllDisplays();
        displayToLay.add(base);
        displayToLay.add(script);
        // La taille des displays est probablement diffrente de ceux qui taient
        // prcdemment. On demande alors le recalcul des display anctres.
        displayToLay.computeAncestorsAttributes();
    }
}
