/***************************************************************************
* Copyright (c) Johan Mabille, Sylvain Corlay and Wolf Vollprecht          *
* Copyright (c) QuantStack                                                 *
*                                                                          *
* Distributed under the terms of the BSD 3-Clause License.                 *
*                                                                          *
* The full license is in the file LICENSE, distributed with this software. *
****************************************************************************/
// This file is generated from test/files/cppy_source/test_extended_xhistogram.cppy by preprocess.py!
// Warning: This file should not be modified directly! Instead, modify the `*.cppy` file.


#include <algorithm>

#include "gtest/gtest.h"
#include "xtensor/xarray.hpp"
#include "xtensor/xtensor.hpp"
#include "xtensor/xhistogram.hpp"

namespace xt
{
    using namespace xt::placeholders;

    /*py

    a = (np.random.random(1000) * 51).astype(np.int)

    count, bin_edges  = np.histogram(a, 50)

    prob, _  = np.histogram(a, 50, density=True)

    */
    TEST(xtest_extended_histogram, histogram_auto)
    {
        // py_a
        xarray<long> py_a = {19,48,37,30, 7, 7, 2,44,30,36, 1,49,42,10, 9, 9,15,26,22,14,31, 7,14,18,
                             23,40,10,26,30, 2,30, 8, 3,48,49,41,15, 4,34,22, 6,25, 1,46,13,33,15,26,
                             27, 9,49,39,47,45,30,47, 4, 9, 2,16,19,13,42,18,14,27, 7,40, 3,50,39,10,
                              0,41,36,37,39, 3,18, 5,44,31,16, 3,15,16,37,32,45,24, 6,36,38,28,39,25,
                             26,21, 1, 5, 1,32,16,25,46,12,20,38,11, 3,14, 8,47,41,32,44,40, 9,45,27,
                             41,45,16, 5,11,21,41,43, 0,26,21,11, 6,17,48,16,26,35,18,49,49,12,25,15,
                             14, 1,31,25, 2,14,46,12, 7,24,50,12,34,38,12,37,18,32,32,27, 4,42,16, 9,
                              2,30,34, 0,26,11,32, 8,35,19,47, 7,17, 5,47,44,13,33,41,28,27,12, 4,45,
                             45,32,17,17,37,45,45,39,32, 4, 8,45,30, 0, 5,33, 0, 8,27,35,33,11,36,12,
                             16,38,33,43,33,28, 4,18,13,12,49,20,45,32,40,25,29,25, 9,36,14, 1,32, 9,
                             47,48,46,18, 0,47,21,49,49,43,15,19,43,16, 8,28,47,35,29, 4,31,50, 7,26,
                             44,37,35,35,18,14,41,41,44,46,26,25,40,33,35,40,45,17,19, 4,29, 1,23,27,
                             14,30, 1, 1,41,18, 6,26,39,11,31, 4, 2,27,27,32,37,49,26,16,40,13,22, 4,
                              1,49,42,35,20, 8, 7,12,28,36,33,14,48,37,28,31,21,12,18,38, 0, 5, 2, 2,
                             43,35,24, 4,25,24, 8,22,20,31,32, 2,19,31,25,43,33, 8, 3,32, 1,29,47,29,
                             19,32,23,27,48,19,49,46, 9, 3, 5, 0, 4,34, 3,16,43, 1,41,14, 6,35,32,44,
                             37,40,14, 9,38,41,50,21,18,39,17,47,43,21,38,38, 5,46,25,42,16,45,19, 0,
                             46, 4,16,48,48,29,32,22,14,16,34,38,40,40, 4,25, 2,28,22,45,17, 5, 7,38,
                             31, 5, 4,35, 3,41,36, 4, 4,50,19,18,41,48,50,38,19, 4,39,28,21,46, 5,25,
                              0,23, 2, 6, 5,33,38,29,49,19,14,44,11,49, 0,49, 2,45,26,50, 3,28,49,26,
                             32,35,23,32,29,45, 2,14,48,45,23,31,14, 9,23,18,29, 3,49,50,35,27,15,41,
                             34, 8,46,41,48,37,31,21,47,44, 2, 1,19,41,50, 7,30,19,49,42,42,23,21,13,
                              2,44,41,50,50,28,39,48,43,12,22, 6,48,30,11,34,31,18, 5,34,26,39,26,43,
                             28,28,44,20, 6, 1,38,31,35,10, 6, 0,17,30,20,22,46,17,26,39,20,31,43,48,
                              7,47,25,13,23,49,25,16,32,12, 3, 6, 6, 7, 7,32, 9,17,45,24,34, 8, 9, 2,
                              8,14, 9, 4, 6,23,10,18,25,35, 2,40,32, 4,44,46, 3,14,41,38, 9,10,18,24,
                             31,18,23,38, 1,12,36,45,26,27, 5,22,27,12,13,19, 1,16,10,16, 6,45,30,34,
                             40,25, 4,27,29,38,22, 6,14,18,32,29,18,50,30,12, 5, 7,12, 8, 9,14, 8,45,
                              4,26,20,50, 5,20,49,44,41,13, 8,34,47,28,29,14,39, 9,16,21,25,12, 5,31,
                             14,29, 7,24,27, 2,17, 6, 3,50,16,41,12,34,38,30,24,21,17,47,42,49, 6,37,
                             47, 9, 3,37,29,42, 7,40,10, 8, 8,41,33,26,18,44,20,41,22,19,23,15,38,25,
                             11,45,19,27,46,31, 5,47,32,17, 7,40,31,27,45,40, 7,15,12,37, 1,29,38,44,
                             17,41, 5,43, 6,20,40, 7,11,36,36,32,35,27,12,17, 9,46,29,20,23,48, 7,29,
                             25,31, 0,44,47,28,35,47,36, 7,29,30,21,37,47,47,22, 5,50,42, 6,46,44,26,
                             30,20, 2,17,40, 0,17,20,27,46,17,17,37,23,11,23, 7, 8,25,21,46,18,29,32,
                              0,33, 9,49, 7,21, 4,50,25,30, 3,38,10,45,10, 9, 1,24,28, 3,39,23,26,22,
                             20,28, 7, 9,43,48,19,13,32,20, 1, 7,36,33, 1,11,11,34, 1, 5,40, 9,33,12,
                              5,12,36,43,42,20,34,10,14,45, 0, 4,10, 1, 9,29,21,45,41,17,13,19,30,13,
                             31,20,28,22,15,48,38, 7,44,24,45,40,21, 1,13,27,32,13, 7,42,50,26, 8,13,
                              0,46, 6,29,13,28,33,42,10, 0, 6,45,44,30,30,33, 8,46,21,19,26, 2, 8,37,
                              4,30,12,19,14,18,36,15,28,24,33,47,37,10, 1,13,30, 2,25,30,17,39, 5, 3,
                             37,25,35,22,12,41,40,35,13,30,18, 4,46, 6,48,22};
        // py_bin_edges
        xarray<double> py_bin_edges = { 0., 1., 2., 3., 4., 5., 6., 7., 8., 9.,10.,11.,12.,13.,14.,15.,16.,17.,
                                       18.,19.,20.,21.,22.,23.,24.,25.,26.,27.,28.,29.,30.,31.,32.,33.,34.,35.,
                                       36.,37.,38.,39.,40.,41.,42.,43.,44.,45.,46.,47.,48.,49.,50.};
        // py_count
        xarray<long> py_count = {18,24,21,18,26,23,21,27,21,24,14,13,24,18,24,11,19,21,23,21,18,18,16,16,
                                 11,24,23,20,19,21,24,20,27,17,14,19,14,18,21,14,20,25,13,14,19,27,20,21,
                                 18,38};
        // py_prob
        xarray<double> py_prob = {0.018,0.024,0.021,0.018,0.026,0.023,0.021,0.027,0.021,0.024,0.014,0.013,
                                  0.024,0.018,0.024,0.011,0.019,0.021,0.023,0.021,0.018,0.018,0.016,0.016,
                                  0.011,0.024,0.023,0.02 ,0.019,0.021,0.024,0.02 ,0.027,0.017,0.014,0.019,
                                  0.014,0.018,0.021,0.014,0.02 ,0.025,0.013,0.014,0.019,0.027,0.02 ,0.021,
                                  0.018,0.038};

        auto bin_edges = xt::histogram_bin_edges(py_a, std::size_t(50));

        auto count = xt::histogram(py_a, bin_edges);

        auto prob = xt::histogram(py_a, bin_edges, true);

        EXPECT_EQ(xt::cast<double>(bin_edges), py_bin_edges);

        EXPECT_EQ(count, xt::cast<double>(py_count));

        EXPECT_EQ(prob, py_prob);
    }

    /*py

    a = (np.random.random(1000) * 51).astype(np.int)

    count, bin_edges  = np.histogram(a, 30, (10, 40))

    */
    TEST(xtest_extended_histogram, histogram_with_range)
    {
        // py_a
        xarray<long> py_a = { 9,27,44,37,41,33,35,43,12,24,11,50,48, 2,35,47, 9,28,46, 1,35,15,47,49,
                             48,24,43,43,16,42, 1,30,11, 6, 3,35,17,36, 3,16,27,40,16,31,45,31,11, 1,
                             44, 1,44,26,47,40,50,17,39,20,24,32,44,50,39,21,21,37,12, 5,18,14,15,11,
                              2, 0,50,21,19,34,11,48,40, 4,21,44,48,23,31, 8,50,11,48,33,30,26,11, 9,
                             11, 9,39,17, 2,49,45,47,50, 8,20,38,35, 7,41,11,11,27,30,29, 4,44,13, 6,
                             45,48,43,41,33,28, 4,20,19,13,36,25, 4,11,34, 3,43,25,24,30,42,17,34,28,
                             13,44,40,33,43,44,36,42,35,34,31,38, 8,44,44, 1,42, 6,17,37, 8,41,42,25,
                              0,14,31,50,32,13,32,27,39, 5,38,27,49,17,32,47, 5,47,35, 3,15,36, 3,29,
                             17,31, 2,44,49,49,38, 6,38, 1, 1,16,24,39,34,22,13,50,21,23, 8,40,35,11,
                              4,34,33,13,48, 7,22,48,21,32,20,13,50,20,45,11,10, 1,33,18,44,24,49, 9,
                             44,39,39,43,38,31, 6, 1,46,31,40,24, 5, 6,34,21,10,25, 3,29,13,40,15,23,
                              0, 3,20,24,30,14,35,43,39, 2,24, 5,12,50, 7,25,31,35,28, 0,16,26, 4,17,
                              1, 4,20, 6,28,35,40,10, 8, 5,32,36, 1,47, 2,27,36,44,36,40,17,41, 4,45,
                             27,41,23,32,26,37, 4, 3,12, 8,44,11,49,17, 9,40,33,25,28,36,11,50,49,33,
                             10,34, 3, 1,13,23,44,37,37,21,17,18,50, 2,44,29,22,36,24,44,45,21,14,30,
                             46,10,31,32,37, 6,36,46, 9,12,49, 9,43,25,12,44,22,26,18,30, 8,19,49,13,
                             33,16,39, 6,49,23,12, 3, 8,26,17,42,21,12,31,36, 8, 8, 1,37,33,24,43,41,
                             29,44,10, 5,13, 2,27,47, 2, 6,23,47,16,25, 2, 7,50,49, 0,48,32,44,23,26,
                             24,34, 7, 1,15,35,10,34,49, 4,34,22,44, 9,35,42,48,34,25,31,44,29, 1,47,
                             35,34,10,33,20,33, 5,33,50, 2,49,20,44,39,28,37,44,20,16,34,41,38,40,22,
                             41, 6,27, 0,16,18,20,35,19,22,12,19,11, 3,30,34,31,23,19,44,26,24, 1,17,
                             19,20,29,27,31,39,41,36,48, 0, 9, 0,33,45,12,47, 3,47,17, 5,24,13,14,15,
                             40,27,15,31,36,13,21, 6, 9,34, 9,26,36, 5,28,13,49,24,41,28, 2,32,48,30,
                             41,45,11,10,31,20,42,45,18,12,39,14,41,21,34, 4,31,23,29, 8,37,44,11, 4,
                              1,32,30,27,11,19,30,25,50, 6,35,20,21,36,35,50, 6, 5,36,29,13, 4, 4,45,
                              9,16,11,18, 3,26, 3,40,11,27,44,33,27,16,16,34,50,33,28,37,23, 3,28,48,
                              8,35,10,27, 4,22,38,17,33,40,47,11,20, 7,50,47,27,42,26,31, 4,38, 6,42,
                             39,36, 1,15,13,18, 4,47,28,15,20,22,30,26,46,25,50,43,10,47, 5,41,19,44,
                             44,41,40,15, 4,20, 8,35,17,49,32,41, 6,43,47,24,30,39, 8,25,20, 7,18, 3,
                              1, 6,49,28,49,22,15,25,22, 5,32,11,31,33, 7, 3,39,23, 2,50, 2,35,50,12,
                              7, 6,15, 5,35, 3,25,50,41,31,15,31,26,21, 6,45,22, 9,18,21,42,37,39, 0,
                             21,24, 0,13,38, 6,27,10, 0,12,49,40,48,24, 5,27,23,43, 5,24, 7,16,37,24,
                             19,20,23,40,45,48,40,16,35,22,12,42, 1,45,23,32,33,45,32,31, 3,26, 7,37,
                             26,34, 2, 4,36, 3, 3, 0,48,37,18,15,17,39,33, 9, 8, 5,33,38,13, 1, 4,49,
                             15,39,31,19,10, 6,31,39,32,27, 2,49,40,14,49,30,29,38,41,33, 6,17,47,11,
                             18,22,22,31,48,12, 6,10,45,32,14,41,43,43,46,12,38,23,42,37,39,33, 9,27,
                             50,47, 2, 8, 6,37,41,10,25,42,37,27,30,25,15,28,35,44,32,38, 8,23, 0,12,
                             37,50, 5,20,40,10,28,37,31, 9,18,39,28, 0,38, 1,38,10,48,18,16, 7,15,44,
                             50,18,22,36,45,30,19,21,35, 0,31,18,40, 4,29,24,32, 3,29,28,28,30,34,41,
                             13,42,25, 3, 2,17,40,36,40,26,22, 7,16,22, 4,11,30,37,50,47,32,21,32,40,
                              6,20,42,19,29,29, 9,18,17, 1, 1,42,13,26,15,47,13,21,44,42, 9,40,23,24,
                              6, 4,37,25,22,37,39, 8,31, 6,38,33,48, 3, 2,14};
        // py_bin_edges
        xarray<double> py_bin_edges = {10.,11.,12.,13.,14.,15.,16.,17.,18.,19.,20.,21.,22.,23.,24.,25.,26.,27.,
                                       28.,29.,30.,31.,32.,33.,34.,35.,36.,37.,38.,39.,40.};
        // py_count
        xarray<long> py_count = {17,25,17,21, 9,18,16,20,17,13,21,19,19,18,22,18,17,21,18,14,18,28,21,24,
                                 20,24,20,23,17,47};

        auto bin_edges = xt::histogram_bin_edges(py_a, 10, 40, std::size_t(30));

        auto count = xt::histogram(py_a, bin_edges);

        EXPECT_EQ(xt::cast<double>(bin_edges), py_bin_edges);

        EXPECT_EQ(count, xt::cast<double>(py_count));
    }
}

